"""
Contains definitions for the MicroPython micro:bit related APIs so they can be
used in the editor for autocomplete and call tips.

Copyright (c) 2015-2016 Nicholas H.Tollervey and others (see the AUTHORS file).

Based upon work done for Puppy IDE by Dan Pope, Nicholas Tollervey and Damien
George.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
# Based upon the help text found in source/microbit/help.c in the
# microbit-micropython repos.
MICROPYTHON_APIS = [
    # System state objects.
    "microbit.panic() \nPut micro:bit in panic() mode and display an unhappy face.\nPress the reset button to exit panic() mode.",
    "microbit.sleep(time) \nPut micro:bit to sleep for some milliseconds (1 second = 1000 ms) of time.\nsleep(2000) gives micro:bit a 2 second nap.",
    "microbit.running_time() \nReturn running_time() in milliseconds since micro:bit's last reset.",
    "microbit.temperature() \nReturn micro:bit's temperature in degrees Celcius.",
    # Accelerometer 3D orientation
    "microbit.accelerometer.get_x() \nReturn micro:bit's tilt (X acceleration) in milli-g's.",
    "microbit.accelerometer.get_y() \nReturn micro:bit's tilt (Y acceleration) in milli-g's.",
    "microbit.accelerometer.get_z() \nReturn micro:bit's up-down motion (Z acceleration) in milli-g's.\nZ is a positive number when moving up. Moving down, Z is a negative number.",
    "microbit.accelerometer.is_gesture(name) \nReturn True or False to indicate if the named gesture is currently active.\nMicroPython understands the following gestures: 'up', 'down', 'left', 'right',\n'face up', 'face down', 'freefall', '3g', '6g', '8g' and 'shake'.",
    "microbit.accelerometer.was_gesture(name) \nReturn True or False to indicate if the named gesture was active since the\nlast call.\nMicroPython understands the following gestures: 'up', 'down', 'left', 'right',\n'face up', 'face down', 'freefall', '3g', '6g', '8g' and 'shake'.",
    "microbit.accelerometer.get_gestures() \nReturn a list indicating the gesture history. The most recent gesture is last.\nCalling this method also clears the gesture history.\nMicroPython understands the following gestures: 'up', 'down', 'left', 'right',\n'face up', 'face down', 'freefall', '3g', '6g', '8g' and 'shake'.",
    # Pushbutton
    "microbit.button_a.is_pressed() \nIf button A is pressed down, is_pressed() is True, else False.",
    "microbit.button_a.was_pressed() \nUse was_pressed() to learn if button A was pressed since the last time\nwas_pressed() was called. Returns True or False.",
    "microbit.button_a.get_presses() \nUse get_presses() to get the running total of button presses, and also\nreset this counter to zero.",
    "microbit.button_b.is_pressed() \nIf button B is pressed down, is_pressed() is True, else False.",
    "microbit.button_b.was_pressed() \nUse was_pressed() to learn if button B was pressed since the last time\nwas_pressed() was called. Returns True or False.",
    "microbit.button_b.get_presses() \nUse get_presses() to get the running total of button presses, and also\nreset this counter to zero.",
    # Compass 3D direction heading
    "microbit.compass.is_calibrated() \nIf micro:bit's compass is_calibrated() and adjusted for accuracy, return True.\nIf compass hasn't been adjusted for accuracy, return False.",
    "microbit.compass.calibrate() \nIf micro:bit is confused, calibrate() the compass to adjust the its accuracy.\nWill ask you to rotate the device to draw a circle on the display. Afterwards, micro:bit will know which way is north.",
    "microbit.compass.clear_calibration() \nReset micro:bit's compass using clear_calibration() command.\nRun calibrate() to improve accuracy.",
    "microbit.compass.get_x() \nReturn magnetic field detected along micro:bit's X axis.\nUsually, the compass returns the earth's magnetic field in micro-Tesla units.\nUnless...a strong magnet is nearby!",
    "microbit.compass.get_y() \nReturn magnetic field detected along micro:bit's Y axis.\nUsually, the compass returns the earth's magnetic field in micro-Tesla units.\nUnless...a strong magnet is nearby!",
    "microbit.compass.get_z() \nReturn magnetic field detected along micro:bit's Z axis.\nUsually, the compass returns the earth's magnetic field in micro-Tesla units.\nUnless...a strong magnet is nearby!",
    "microbit.compass.get_field_strength() \nReturn strength of magnetic field around micro:bit.",
    "microbit.compass.heading() \nReturn a number between 0-360 indicating the device's heading. 0 is north.",
    # Display 5x5 LED grid
    "microbit.display.show(x, delay=400, wait=True, loop=False, clear=False) \nUse show(x) to print the string or image 'x' to the display. If 'x' is a list\nof images they will be animated together.\nUse 'delay' to specify the speed of frame changes in milliseconds.\nIf wait is False animation will happen in the background while the program continues.\nIf loop is True the animation will repeat forever.\nIf clear is True the display will clear at the end of the animation.",
    "microbit.display.scroll(string, delay=150, wait=True, loop=False, monospace=False) \nUse scroll(string) to scroll the string across the display.\nUse delay to control how fast the text scrolls.\nIf wait is False the text will scroll in the background while the program continues.\nIf loop is True the text will repeat forever.\nIf monospace is True the characters will always take up 5 pixel-columns.",
    "microbit.display.clear() \nUse clear() to clear micro:bit's display.",
    "microbit.display.get_pixel(x, y) \nUse get_pixel(x, y) to return the display's brightness at LED pixel (x,y).\nBrightness can be from 0 (LED is off) to 9 (maximum LED brightness).",
    "microbit.display.set_pixel(x, y, b) \nUse set_pixel(x, y, b) to set the display at LED pixel (x,y) to brightness 'b'\nwhich can be set between 0 (off) to 9 (full brightness).",
    "microbit.display.on() \nUse on() to turn on the display.",
    "microbit.display.off() \nUse off() to turn off the display.",
    "microbit.display.is_on() \nUse is_on() to query if the micro:bit's display is on (True) or off (False).",
    # Pins
    "microbit.pin0.is_touched() \nIf pin0 is_touched() on micro:bit, return True. If nothing is touching the\npin, return False.",
    "microbit.pin0.read_digital() \nread_digital() value from pin0. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin0.write_digital(value) \nSet pin0 to output high if value is 1, or to low, it it is 0.",
    "microbit.pin0.read_analog() \nRead the voltage applied to pin0. Return the reading as a number between\n0 (meaning 0v) and 1023 (meaning 3.3v).",
    "microbit.pin0.write_analog(value) \nSet pin0 to output a value between 0 and 1023.",
    "microbit.pin0.set_analog_period(period) \nSet the period of the PWM signal output to period milliseconds.",
    "microbit.pin0.set_analog_period_microseconds(period) \nSet the period of the PWM signal output to period microseconds.",

    "microbit.pin1.is_touched() \nIf pin1 is_touched() on micro:bit, return True. If nothing is touching the\npin, return False.",
    "microbit.pin1.read_digital() \nread_digital() value from pin1. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin1.write_digital(value) \nSet pin1 to output high if value is 1, or to low, it it is 0.",
    "microbit.pin1.read_analog() \nRead the voltage applied to pin1. Return the reading as a number between\n0 (meaning 0v) and 1023 (meaning 3.3v).",
    "microbit.pin1.write_analog(value) \nSet pin1 to output a value between 0 and 1023.",
    "microbit.pin1.set_analog_period(period) \nSet the period of the PWM signal output to period milliseconds.",
    "microbit.pin1.set_analog_period_microseconds(period) \nSet the period of the PWM signal output to period microseconds.",

    "microbit.pin2.is_touched() \nIf pin2 is_touched() on micro:bit, return True. If nothing is touching the\npin, return False.",
    "microbit.pin2.read_digital() \nread_digital() value from pin2. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin2.write_digital(value) \nSet pin2 to output high if value is 1, or to low, it it is 0.",
    "microbit.pin2.read_analog() \nRead the voltage applied to pin2. Return the reading as a number between\n0 (meaning 0v) and 1023 (meaning 3.3v).",
    "microbit.pin2.write_analog(value) \nSet pin2 to output a value between 0 and 1023.",
    "microbit.pin2.set_analog_period(period) \nSet the period of the PWM signal output to period milliseconds.",
    "microbit.pin2.set_analog_period_microseconds(period) \nSet the period of the PWM signal output to period microseconds.",

    "microbit.pin3.read_digital() \nread_digital() value from pin3. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin2.write_digital(value) \nSet pin3 to output high if value is 1, or to low, it it is 0.",
    "microbit.pin3.read_analog() \nRead the voltage applied to pin3. Return the reading as a number between\n0 (meaning 0v) and 1023 (meaning 3.3v).",
    "microbit.pin3.write_analog(value) \nSet pin3 to output a value between 0 and 1023.",
    "microbit.pin3.set_analog_period(period) \nSet the period of the PWM signal output to period milliseconds.",
    "microbit.pin3.set_analog_period_microseconds(period) \nSet the period of the PWM signal output to period microseconds.",

    "microbit.pin4.read_digital() \nread_digital() value from pin4. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin4.write_digital(value) \nSet pin4 to output high if value is 1, or to low, it it is 0.",
    "microbit.pin4.read_analog() \nRead the voltage applied to pin4. Return the reading as a number between\n0 (meaning 0v) and 1023 (meaning 3.3v).",
    "microbit.pin4.write_analog(value) \nSet pin4 to output a value between 0 and 1023.",
    "microbit.pin4.set_analog_period(period) \nSet the period of the PWM signal output to period milliseconds.",
    "microbit.pin4.set_analog_period_microseconds(period) \nSet the period of the PWM signal output to period microseconds.",

    "microbit.pin5.read_digital() \nread_digital() value from pin5. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin5.write_digital(value) \nSet pin5 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin6.read_digital() \nread_digital() value from pin6. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin6.write_digital(value) \nSet pin6 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin7.read_digital() \nread_digital() value from pin7. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin7.write_digital(value) \nSet pin7 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin8.read_digital() \nread_digital() value from pin8. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin8.write_digital(value) \nSet pin8 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin9.read_digital() \nread_digital() value from pin9. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin9.write_digital(value) \nSet pin9 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin10.read_digital() \nread_digital() value from pin10. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin10.write_digital(value) \nSet pin10 to output high if value is 1, or to low, it it is 0.",
    "microbit.pin10.read_analog() \nRead the voltage applied to pin10. Return the reading as a number between\n0 (meaning 0v) and 1023 (meaning 3.3v).",
    "microbit.pin10.write_analog(value) \nSet pin10 to output a value between 0 and 1023.",
    "microbit.pin10.set_analog_period(period) \nSet the period of the PWM signal output to period milliseconds.",
    "microbit.pin10.set_analog_period_microseconds(period) \nSet the period of the PWM signal output to period microseconds.",

    "microbit.pin11.read_digital() \nread_digital() value from pin11. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin11.write_digital(value) \nSet pin11 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin12.read_digital() \nread_digital() value from pin12. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin12.write_digital(value) \nSet pin12 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin13.read_digital() \nread_digital() value from pin13. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin13.write_digital(value) \nSet pin13 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin14.read_digital() \nread_digital() value from pin14. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin14.write_digital(value) \nSet pin14 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin15.read_digital() \nread_digital() value from pin15. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin15.write_digital(value) \nSet pin15 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin16.read_digital() \nread_digital() value from pin16. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin16.write_digital(value) \nSet pin16 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin19.read_digital() \nread_digital() value from pin19. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin19.write_digital(value) \nSet pin19 to output high if value is 1, or to low, it it is 0.",

    "microbit.pin20.read_digital() \nread_digital() value from pin20. The reading will be either 0 (lo) or 1 (hi).",
    "microbit.pin20.write_digital(value) \nSet pin20 to output high if value is 1, or to low, it it is 0.",
    # I2C
    "microbit.i2c.read(address, n, repeat=False) \nUse read(address, n) to read 'n' bytes from the device with the 7-bit address.\nIf repeat is True, no stop bit will be sent.",
    "microbit.i2c.write(adress, buffer, repeat=False) \nUse write(address, buffer) to write to the 'buffer' of the device at the 7-bit 'address'.\nIf repeat is True, no stop bit will be sent.",
    # Image
    "microbit.Image(string) \nCreate and use built-in IMAGES to show on the display. Use:\nImage(\n  '09090:'\n  '99999:'\n  '99999:'\n  '09990:'\n  '00900:')\n...to make a new 5x5 heart image. Numbers go from 0 (off) to 9 (brightest). Note\nthe colon ':' to set the end of a row.",
    "microbit.Image.width() \nReturn the width of the image in pixels.",
    "microbit.Image.height() \nReturn the height of the image in pixels.",
    "microbit.Image.get_pixel(x, y) \nUse get_pixel(x, y) to return the image's brightness at LED pixel (x,y).\nBrightness can be from 0 (LED is off) to 9 (maximum LED brightness).",
    "microbit.Image.set_pixel(x, y, b) \nUse set_pixel(x, y, b) to set the LED pixel (x,y) in the image to brightness\n'b' which can be set between 0 (off) to 9 (full brightness).",
    "microbit.Image.shift_left(n) \nUse shift_left(n) to make a copy of the image but moved 'n' pixels to the left.",
    "microbit.Image.shift_right(n) \nUse shift_right(n) to make a copy of the image but moved 'n' pixels to\nthe right.",
    "microbit.Image.shift_up(n) \nUse shift_up(n) to make a copy of the image but moved 'n' pixels up.",
    "microbit.Image.shift_down(n) \nUse shift_down(n) to make a copy of the image but moved 'n' pixels down.",
    "microbit.Image.copy() \nUse copy() to make a new exact copy of the image.",
    "microbit.Image.crop(x1, y1, x2, y2) \nUse crop(x1, y1, x2, y2) to make a cut-out copy of the image where coordinate\n(x1,y1) is the top left corner of the cut-out area and coordinate (x2,y2) is the\nbottom right corner.",
    "microbit.Image.invert() \nUse invert() to make a negative copy of the image. Where a pixel was bright or\non in the original, it is dim or off in the negative copy.",
    "microbit.Image.HEART",
    "microbit.Image.HEART_SMALL",
    "microbit.Image.HAPPY",
    "microbit.Image.SMILE",
    "microbit.Image.SAD",
    "microbit.Image.CONFUSED",
    "microbit.Image.ANGRY",
    "microbit.Image.ASLEEP",
    "microbit.Image.SURPRISED",
    "microbit.Image.SILLY",
    "microbit.Image.FABULOUS",
    "microbit.Image.MEH",
    "microbit.Image.YES",
    "microbit.Image.NO",
    "microbit.Image.CLOCK12",
    "microbit.Image.CLOCK11",
    "microbit.Image.CLOCK10",
    "microbit.Image.CLOCK9",
    "microbit.Image.CLOCK8",
    "microbit.Image.CLOCK7",
    "microbit.Image.CLOCK6",
    "microbit.Image.CLOCK5",
    "microbit.Image.CLOCK4",
    "microbit.Image.CLOCK3",
    "microbit.Image.CLOCK2",
    "microbit.Image.CLOCK1",
    "microbit.Image.ARROW_N",
    "microbit.Image.ARROW_NE",
    "microbit.Image.ARROW_E",
    "microbit.Image.ARROW_SE",
    "microbit.Image.ARROW_S",
    "microbit.Image.ARROW_SW",
    "microbit.Image.ARROW_W",
    "microbit.Image.ARROW_NW",
    "microbit.Image.TRIANGLE",
    "microbit.Image.TRIANGLE_LEFT",
    "microbit.Image.CHESSBOARD",
    "microbit.Image.DIAMOND",
    "microbit.Image.DIAMOND_SMALL",
    "microbit.Image.SQUARE",
    "microbit.Image.SQUARE_SMALL",
    "microbit.Image.RABBIT",
    "microbit.Image.COW",
    "microbit.Image.MUSIC_CROTCHET",
    "microbit.Image.MUSIC_QUAVER",
    "microbit.Image.MUSIC_QUAVERS",
    "microbit.Image.PITCHFORK",
    "microbit.Image.XMAS",
    "microbit.Image.PACMAN",
    "microbit.Image.TARGET",
    "microbit.Image.TSHIRT",
    "microbit.Image.ROLLERSKATE",
    "microbit.Image.DUCK",
    "microbit.Image.HOUSE",
    "microbit.Image.TORTOISE",
    "microbit.Image.BUTTERFLY",
    "microbit.Image.STICKFIGURE",
    "microbit.Image.GHOST",
    "microbit.Image.SWORD",
    "microbit.Image.GIRAFFE",
    "microbit.Image.SKULL",
    "microbit.Image.UMBRELLA",
    "microbit.Image.SNAKE",
    "microbit.Image.ALL_CLOCKS",
    "microbit.Image.ALL_ARROWS",

    # uart
    "microbit.uart.init(baudrate=9600, bits=8, parity=None, stop=1, tx=None, rx=None) \nUse init() to set up communication using the default values. \nOtherwise override the defaults as named arguments.",
    "microbit.uart.any() \nIf there are incoming characters waiting to be read, any() will return True.\nOtherwise, returns False.",
    "microbit.uart.read(n) \nUse read() to read characters.\nUse read(n) to read, at most, 'n' bytes of data.",
    "microbit.uart.readall() \nUse readall() to read as much data as possible.",
    "microbit.uart.readline() \nUse readline() to read a line that ends with a newline character.",
    "microbit.uart.readinto(buf, n) \nUse readinto(buf) to read bytes into the buffer 'buf'.\nUse readinto(buff, n) to read, at most, 'n' number of bytes into 'buf'.",
    "microbit.uart.write() \nUse write(buf) to write the bytes in buffer 'buf' to the connected device.",

    # SPI
    "microbit.spi.init(baudrate=1000000, bits=8, mode=0, sclk=pin13, mosi=pin15, miso=pin14) \nSet up communication. Override the defaults for baudrate, mode,\nSCLK, MOSI and MISO. The default connections are pin13 for SCLK, pin15 for\nMOSI and pin14 for MISO.",
    "microbit.spi.write(buf) \nUse write(buf) to write bytes in buffer 'buf' to the connected device.",
    "microbit.spi.read(n) \nUse read(n) to read 'n' bytes of data.",
    "microbit.spi.write_readinto(out, in) \nUse write_readinto(out, in) to write the 'out' buffer to the connected device\nand read any response into the 'in' buffer. The length of the buffers should\nbe the same. The buffers can be the same object.",

    # Music module
    "music.set_tempo(number, bpm) \nMake a beat last a 'number' of ticks long and\nplayed at 'bpm' beats per minute.",
    "music.pitch(freq, length=-1, pin=microbit.pin0, wait=True) \nMake micro:bit play a note at 'freq' frequency for\n'length' milliseconds. E.g. pitch(440, 1000) will play concert 'A' for 1 second.\nIf length is a negative number the pitch is played continuously.\nUse the optional pin argument to override the default output for the speaker.\nIf wait is False the music will play in the background while the program\ncontinues.",
    "music.play(music, pin=microbit.pin0, wait=True, loop=False) \nMake micro:bit play 'music' list of notes. Try out the built in music to see\nhow it works. E.g. music.play(music.PUNCHLINE).\nUse the optional pin argument to override the default output for the speaker.\nIf wait is False the music will play in the background while the program\ncontinues.\nIf loop is True, the tune will repeat.",
    "music.get_tempo() \nReturn the number of ticks in a beat and number of beats per minute.",
    "music.stop(pin=microbit.pin0) \nStops all music playback on the given pin. If no pin is given, pin0 is assumed.",
    "music.reset()\nIf things go wrong, reset() the music to its default settings.",
    "music.DADADADUM",
    "music.ENTERTAINER",
    "music.PRELUDE",
    "music.ODE",
    "music.NYAN",
    "music.RINGTONE",
    "music.FUNK",
    "music.BLUES",
    "music.BIRTHDAY",
    "music.WEDDING",
    "music.FUNERAL",
    "music.PUNCHLINE",
    "music.PYTHON",
    "music.BADDY",
    "music.CHASE",
    "music.BA_DING",
    "music.WAWAWAWAA",
    "music.JUMP_UP",
    "music.JUMP_DOWN",
    "music.POWER_UP",
    "music.POWER_DOWN"
    # Antigravity
    "antigravity",
    # This module
    "this.authors() \nUse authors() to reveal the names of the people who created this software.",
    # Love module
    "love.badaboom()\nHear my soul speak:\nThe very instant that I saw you, did\nMy heart fly to your service.",
    # NeoPixel module
    "neopixel.NeoPixel(pin, n) \nCreate a list representing a strip of 'n' neopixels controlled from the\nspecified pin (e.g. microbit.pin0).\nUse the resulting object to change each pixel by position (starting from 0).\nIndividual pixels are given RGB (red, green, blue) values between 0-255 as a\ntupe. For example, (255, 255, 255) is white:\n\nnp = neopixel.NeoPixel(microbit.pin0, 8)\nnp[0] = (255, 0, 128)\nnp.show()",
    "neopixel.NeoPixel.clear() \nClear all the pixels.",
    "neopixel.NeoPixel.show() \nShow the pixels. Must be called for any updates to become visible.",
    # RNG
    "random.getrandbits(n) \nReturn an integer with n random bits.",
    "random.seed(n) \nInitialise the random number generator with a known integer 'n'.",
    "random.randint(a, b) \nReturn a random whole number between a and b (inclusive).",
    "random.randrange(stop) \nReturn a random whole number between 0 and up to (but not including) stop.",
    "random.choice(seq) \nReturn a randomly selected element from a sequence of objects (such as a list).",
    "random.random() \nReturn a random floating point number between 0.0 and 1.0.",
    "random.uniform(a, b) \nReturn a random floating point number between a and b (inclusive).",
    # OS
    "os.listdir() \nReturn a list of the names of all the files contained within the local\non-device file system.",
    "os.remove(filename) \nRemove (delete) the file named filename.",
    "os.size(filename) \nReturn the size, in bytes, of the file named filename.",
    "os.uname() \nReturn information about MicroPython and the device.",
    # SYS
    "sys.version",
    "sys.version_info",
    "sys.implementation",
    "sys.platform",
    "sys.byteorder",
    "sys.print_exception(ex) \nPrint to the REPL information about the exception 'ex'.",
    # String functions
    "find(sub, start, end) \nReturn the lowest index in the string where substring 'sub' is found. The optional\n'start' and 'end' arguments specify the slice of string to use.\nReturns -1 if 'sub' cannot be found.",
    "rfind(sub, start, end) \nReturn the highest index in the string where substring 'sub' is found. The optional\n'start' and 'end' arguments specify the slice of string to use.\nReturns -1 if 'sub' cannot be found.",
    "index(sub, start, end) \nReturn the lowest index in the string where substring 'sub' is found. The optional\n'start' and 'end' arguments specify the slice of string to use.\nRaises a ValueError if 'sub' cannot be found.",
    "rindex(sub, start, end) \nReturn the highest index in the string where substring 'sub' is found. The optional\n'start' and 'end' arguments specify the slice of string to use.\nRaises a ValueError if 'sub' cannot be found.",
    "join(iterable) \nReturn a string which is the concatenation of the strings in 'iterable'.\nThe separator between elements is the string providing this method.",
    "split(sep=None, maxsplit=-1) \nReturn a list of the words in a string, using 'sep' as the delimiter string.\nIf 'sep' is not provided, the splitting algorithm uses whitespace.\nIf the optional 'maxsplit' is provided, splitting will occur 'maxsplit' times.",
    "rsplit(sep=None, maxsplit=-1) \nReturn a list of the words in a string, using 'sep' as the delimiter string.\nIf 'sep' is not provided, the splitting algorithm uses whitespace.\nIf the optional 'maxsplit' is provided, splitting will only occur 'maxsplit'\ntimes from the right.",
    "startswith(prefix) \nReturns True if the string starts with 'prefix'.",
    "endswith(suffix) \nReturns True if the string ends with 'suffix'.",
    "strip(chars) \nReturn a copy of the string with the leading and trailing characters removed.\nThe chars argument is a string specifying the set of characters to be removed.\nIf omitted or None, the chars argument defaults to removing whitespace.\nThe chars argument is not a prefix or suffix; rather, all combinations of its values are stripped",
    "lstrip(chars) \nReturn a copy of the string with leading characters removed. The chars argument\nis a string specifying the set of characters to be removed.\nIf omitted or None, the chars argument defaults to removing whitespace.\nThe chars argument is not a prefix; rather, all combinations of its values are\nstripped",
    "rstrip(chars) \nReturn a copy of the string with trailing characters removed. The chars argument\nis a string specifying the set of characters to be removed.\nIf omitted or None, the chars argument defaults to removing whitespace.\nThe chars argument is not a suffix; rather, all combinations of its values are\nstripped",
    "format(*args, **kwargs) \nPerform a string formatting operation. The string on which this method is called\ncan contain literal text or replacement fields delimited by braces {}. Each\nreplacement field contains either the numeric index of a positional argument,\nor the name of a keyword argument.\nReturns a copy of the string where each replacement field is replaced with the\nstring value of the corresponding argument.",
    "replace(old, new) \nReturn a copy of the string with all othe occurrences of 'old' replaced with 'new'.",
    "count(sub, start, end) \nReturn the number of non-overlapping occurrences of substring 'sub'.\nOptional arguments 'start' and 'end' specify the slice of the string to use. ",
    "partition(sep) \nSplit the string at the first occurrence of 'sep', and return a 3-tuple containing\nthe part before the separator, the separator itself, and the part after the separator.\nIf the separator is not found, return a 3-tuple containing the string itself,\nfollowed by two empty strings.",
    "rpartition(sep) \nSplit the string at the last occurrence of 'sep', and return a 3-tuple containing\nthe part before the separator, the separator itself, and the part after the separator.\nIf the separator is not found, return a 3-tuple containing two empty strings,\nfollowed by the string itself.",
    "lower() \nReturn a copy of the string with all the cased characters converted to lowercase.",
    "upper() \nReturn a copy of the string with all the cased characters converted to uppercase.",
    "isspace() \nReturn True if there are only whitespace characters in the string and thers is\nat least one character.",
    "isalpha() \nReturn True if all the characters in the string are alphabetic and there is\nat least one character.",
    "isdigit() \nReturn True if all characters in the string are digits and there is\nat least one character.",
    "isupper() \nReturn True if all characters in the string are uppercase and there is\nat least one character.",
    "islower() \nReturn True if all characters in the string are lowercase and there is\nat least one character.",
    # Math functions
    "math.sqrt(x) \nReturn the square root of 'x'.",
    "math.pow(x, y) \nReturn 'x' raised to the power 'y'.",
    "math.exp(x) \nReturn math.e**'x'.",
    "math.log(x, base=math.e) \nWith one argument, return the natural logarithm of 'x' (to base e).\nWith two arguments, return the logarithm of 'x' to the given 'base'.",
    "math.cos(x) \nReturn the cosine of 'x' radians.",
    "math.sin(x) \nReturn the sine of 'x' radians.",
    "math.tan(x) \nReturn the tangent of 'x' radians.",
    "math.acos(x) \nReturn the arc cosine of 'x', in radians.",
    "math.asin(x) \nReturn the arc sine of 'x', in radians.",
    "math.atan(x) \nReturn the arc tangent of 'x', in radians.",
    "math.atan2(x, y) \nReturn atan(y / x), in radians.",
    "math.ceil(x) \nReturn the ceiling of 'x', the smallest integer greater than or equal to 'x'.",
    "math.copysign(x, y) \nReturn a float with the magnitude (absolute value) of 'x' but the sign of 'y'. ",
    "math.fabs(x) \nReturn the absolute value of 'x'.",
    "math.floor(x) \nReturn the floor of 'x', the largest integer less than or equal to 'x'.",
    "math.fmod(x, y) \nReturn 'x' modulo 'y'.",
    "math.frexp(x) \nReturn the mantissa and exponent of 'x' as the pair (m, e). ",
    "math.ldexp(x, i) \nReturn 'x' * (2**'i').",
    "math.modf(x) \nReturn the fractional and integer parts of x.\nBoth results carry the sign of x and are floats.",
    "math.isfinite(x) \nReturn True if 'x' is neither an infinity nor a NaN, and False otherwise.",
    "math.isinf(x) \nReturn True if 'x' is a positive or negative infinity, and False otherwise.",
    "math.isnan(x) \nReturn True if 'x' is a NaN (not a number), and False otherwise.",
    "math.trunc(x) \nReturn the Real value 'x' truncated to an Integral (usually an integer).",
    "math.radians(x) \nConvert angle 'x' from degrees to radians.",
    "math.degrees(x) \nConvert angle 'x' from radians to degrees.",
    # built-in functions
    "abs(x) \nReturn the absolute value of the number 'x'.",
    "all(iterable) \nReturn True if all elements of iterable are true (or iterable is empty).",
    "any(iterable) \nReturn True if any element of iterable is true. If iterable is empty, return False.",
    "bin(x) \nConvert an integer (whole) number into a binary string.",
    "bool(x) \nReturn a Boolean value, i.e. one of True or False. The argument 'x' is used to\ngenerate the resulting truth value.",
    "bytearray(seq) \nReturn a new array of bytes specified by the sequence 'seq' of integers.",
    "bytes(seq) \nReturn a new 'bytes' object - an immutable sequence of 'seq' integers.",
    "callable(object) \nReturn True if the 'object' appears to be callable. Otherwise return False.",
    "chr(i) \nReturn a string representing a character whose Unicode code point is the integer 'i'.",
    "classmethod(function) \nReturn a class method for a function. Usually used as a decorator:\n\nclass C:\n  @classmethod\n  def func(cls): ...",
    "dict(): \nCreate a new dictionary object.",
    "dir(object) \nReturn a list of names in the scope of 'object'. If no object is supplied,\nreturns a ist of names in the current local scope.",
    "divmod(a, b) \nTake two (non complex) numbers and return a pair of numbers consisting of the quotient and remainder. For example, divmod(5, 4) results in (1, 1). That is, what's is 5 divided by 4? It's 1 remainder 1.",
    "enumerate(iterable, start=0) \nReturn an enumerate object from an iterable object.\nEach iteration of the resulting object returns a tuple containing a count and the value. For example:\n\nseasons = ['Spring', 'Summer', 'Autumn', 'Winter']\nlist(enumerate(seasons))\n[(0, 'Spring'), (1, 'Summer'), (2, 'Fall'), (3, 'Winter')]",
    "eval(expression, globals=None, locals=None) \nThe 'expression' string containing a Python expression is parsed and evaluated given\nthe context specified by 'globals' and 'locals' which must be dictionary objects.",
    "exec(object, globals, locals) \nThis function supports dynamic execution of Python code. The 'object' must be\na string containing Python code that can be parsed and evaluated. If `globals` and\n`locals` are emitted the code is executed in the local scope. Otherwise, both\n'globals' and 'locals' must be dictionary objects.",
    "filter(function, iterable) \nConstruct an iterator from those elements of 'iterable' for which 'function' returns True.",
    "float(x) \nReturn a floating point number constructed from a number or string 'x'.",
    "frozenset(iterable) \nReturn a new frozenset object, optionally with elements taken from 'iterable'.",
    "getattr(object, name, default) \nReturn the value fo the named attribute of 'object'. 'name' must be a string.\nOptionally return 'default' if 'name' is not an attribute of 'object'.",
    "globals() \nReturn a dictionary representing the current global symbol table.\nI.e. named objects that are currently in the global scope.",
    "hasattr(object, name) \nReturns True if the 'object' has an attribute called 'name'. 'name' must be a string.",
    "hash(object) \nReturn a hash value of the object (if it has one). Hash values are integers.",
    "help(object) \nInvoke the built-in help system (intended for interactive use in the REPL.",
    "hex(x) \nConvert an integer 'x' to a lowercase hexadevimal string prefixed with '0x'. For example, hex(255) returns '0xff'.",
    "id(object) \nReturn the identity of an object. This is an integer that is guaranteed to be unique.",
    "int(x, base=10) \nReturn an integer constructed from a number or string 'x'. The optional 'base' (indicating the base of the number) defaults to 10.",
    "isinstance(object, classinfo) \nReturn True if the 'object' is an instance of 'classinfo'.",
    "issubclass(class, classinfo) \nReturn True if the 'class' is a subclass (direct, indirect or virtual) of 'classinfo'.",
    "iter(object) \nReturn an iterator object for the 'object' (that must support the iteration protocol.",
    "len(object) \nReturn the length (the number of items) in an 'object'.",
    "list(iterable) \nReturn a list, optionally based upon the members of 'iterable'.",
    "locals() \nReturn a dictionary representing the current local symbol table. I.e. named objects\nthat are currently in the local scope.",
    "map(function, iterable) \nReturn an iterator that applies 'function' to every item of 'iterable', yielding the results.",
    "max(items) \nReturn the largest item in 'items', which can be either an iterable or two or more arguments.",
    "min(items) \nReturn the smallest item in 'items', which can be either an iterable or two or more arguments.",
    "next(iterator) \nRetrieve the next item from the iterator.",
    "object() \nReturn a new featureless object.",
    "oct(x) \nConvert an integer number to an octal (base 8) string.",
    "open(file, mode='rt') \nOpen 'file' and return a corresponding file object. The 'mode' is an optional\nstring that specifies how the file is opened:\n'r' - open for reading\n'w' - open for writing\n'b' - binary mode\n't' - text mode.",
    "ord(c) \nGiven a string representing one Unicode character, return an integer representing the Unicode code point of that character.",
    "pow(x, y, z) \nReturn 'x' to the power of 'y'. If the optional 'z' is given, return 'x' to the power of 'y' modulo 'z' (giving the remainder).",
    "print(*objects, sep=' ', end='\\n') \nPrint objects, separated by 'sep' and followed by 'end'. All non-keyword arguments are converted to strings.",
    "range(start, stop, step) \nReturn an immutable sequence containing items between 'start' and 'stop' with 'step' difference between them.",
    "repr(object) \nReturn a string containing a printable representation of an 'object'.",
    "reversed(seq) \nReturn a reverse iterator of the sequence 'seq'.",
    "round(number, ndigits) \nReturn the floating point 'number' rounded to the (optional) 'ndigits'.\nIf 'ndigits' is omitted, round to the nearest whole number.",
    "set(iterable) \nReturn a new set object, optionally containing elements taken from iterable.",
    "setattr(object, name, value) \nSet the 'value' to the attribute called 'name' on object 'object'. 'name' must be a string.",
    "sorted(iterable, key, reverse) \nReturn a new sorted list from the items in iterable. The optional 'key' specifies\na function used for comparison and the optional 'reverse' is a boolean indicating the comparison should be reversed.",
    "staticmethod(function) \nReturns a static method for a function. Usually used as a decorator:\n\nclass C:\n  @staticmethod\ndef func(): ...",
    "str(object) \nReturn a string version of 'object'.",
    "sum(iterable, start=0) \nSums 'start' and items of an iterable from left to right and returns the total.",
    "super(type, object-or-type) \nReturn a proxy object that delegates method calls to a parent or sibling class\nof 'type'. This is useful for accessing inherited methods that have been\noverridden in a class.",
    "tuple(iterable) \nReturn an immutable sequence based upon the items in 'iterable'.",
    "type(object) \nReturn the type of an object (i.e. what sort of thing it is).",
    "zip(*iterables) \nMake an iterator that aggregates elements from each of the passed in iterables.\nFor example:\nx = [1, 2, 3]\ny = [4, 5, 6]\nlist(zip(x, y))\n[(1, 4), (2, 5), (3, 6)]",
    # Radio
    "radio.on() \nTurns on the radio. This needs to be called since the radio draws power and\ntakes up memory that you may otherwise need.",
    "radio.off() \nTurns off the radio, thus saving power and memory.",
    "radio.config(length=32, queue=3, channel=7, power=0, address=0x75626974, group=0, data_rate=radio.RATE_1MBIT) \nConfigures the various settings relating to the radio. The specified default\nvalues are sensible.\n'length' is the maximum length, in bytes, of a message. It can be up to 251\nbytes long.\n'queue' is the number of messages to store on the message queue.\n'channel' (0-100) defines the channel to which the radio is tuned.\n'address' is an arbitrary 32-bit address that's used to filter packets.\n'group' is an 8-bit value used with 'address' when filtering packets.\n'data_rate' is the throughput speed. It can be one of: radio.RATE_250KbIT,\nradio.RATE_1MbIT (the default) or radio.2MBIT.",
    "radio.reset() \nReset the settings to their default value.",
    "radio.send_bytes(message) \nSends a message containing bytes.",
    "radio.receive_bytes() \nReceive the next incoming message from the message queue. Returns 'None' if\nthere are no pending messages. Messages are returned as bytes.",
    "radio.send(message) \nSend a message string.",
    "radio.receive() \nReceive the next incoming message from the message queue as a string. Returns\n'None' if there are no pending messages.",
    "radio.RATE_250KBIT",
    "radio.RATE_1MBIT",
    "radio.RATE_2MBIT",
    # Audio
    "audio.play(source, wait=True, pins=(pin0, pin1)) \nPlay the source to completion where 'source' is an iterable, each element of\nwhich must be an AudioFrame instance.",
    "audio.AudioFrame()() \nRepresents a list of 32 samples each of which is a signed byte. It takes just\nover 4ms to play a single frame.",
    # Speech
    "speech.translate(words) \nReturn a string containing the phonemes for the English words in the string\n'words'.",
    "speech.say(words, pitch=64, speed=72, mouth=128, throat=128) \nSay the English words in the string 'words'. Override the optional pitch,\nspeed, mouth and throat settings to change the tone of voice.",
    "speech.pronounce(phonemes, pitch=64, speed=72, mouth=128, throat=128) \nPronounce the phonemes in the string 'phonemes'. Override the optional pitch,\nspeed, mouth and throat settings to change the tone of voice.",
    "speech.sing(song, pitch=64, speed=72, mouth=128, throat=128) \nSing the phonemes in the string 'song'. Add pitch information to a phoneme\nwith a hash followed by a number between 1-255 like this: '#112DOWWWWWWWW'.\nOverride the optional pitch, speed, mouth and throat settings to change the\ntone of voice.",
]
