/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package at.redeye.FrameWork.base.bindtypes;

import java.util.Vector;

import at.redeye.FrameWork.base.bindtypes.DBEnum.EnumHandler;

/**
 *
 * @author martin
 */

    public class CurrencyEnumHandler extends DBEnum.EnumHandler
    {
        public enum CURRENCY
        {
            // from http://de.wikipedia.org/wiki/ISO_4217
            AED, //AED 	784 	Dirham 	100 Fils 	Vereinigte Arabische Emirate
            AFN, //AFN 	971 	Afghani 	100 Puls 	Afghanistan 	2002
            ALL, //ALL 	008 	Lek 	100 Qindarka 	Albanien
            AMD, //AMD 	051 	Dram 	100 Lumma 	Armenien
            ANG, //ANG 	532 	Gulden 	100 Cents 	Niederländische Antillen
            AOA, //AOA 	973 	Kwanza 	100 Lwei 	Angola 	1999
            ARS, //ARS 	032 	Peso 	100 Centavos 	Argentinien 	1991
            AUD, //AUD 	036 	Dollar 	100 Cents 	Australien, Kiribati, Nauru, Tuvalu
            AWG, //AWG 	533 	Florin 	100 Cents 	Aruba
            AZN, //AZN 	944 	Manat 	100 Qäpik 	Aserbaidschan 	2006
            BAM, //BAM 	977 	Konvertible Mark 	100 Fening 	Bosnien und Herzegowina 	1999
            BBD, //BBD 	052 	Dollar 	100 Cents 	Barbados
            BDT, //BDT 	050 	Taka 	100 Poisha 	Bangladesch
            BGN, //BGN 	975 	Lew 	100 Stotinki 	Bulgarien 	1999
            BHD, //BHD 	048 	Dinar 	1000 Fils 	Bahrain
            BIF, //BIF 	108 	Franc 	100 Centimes 	Burundi
            BMD, //BMD 	060 	Dollar 	100 Cents 	Bermuda
            BND, //BND 	096 	Dollar 	100 Cents 	Brunei
            BOB, //BOB 	068 	Boliviano 	100 Centavos 	Bolivien 	1987
            BOV, //BOV 	984 	Mvdol
            BRL, //BRL 	986 	Real 	100 Centavos 	Brasilien 	1994
            BSD, //BSD 	044 	Dollar 	100 Cents 	Bahamas
            BTN, //BTN 	064 	Ngultrum 	100 Chetrum 	Bhutan
            BWP, //BWP 	072 	Pula 	100 Thebe 	Botsuana
            BYR, //BYR 	974 	Rubel 	100 Kupeken 	Weißrussland 	2000
            BZD, //BZD 	084 	Dollar 	100 Cents 	Belize
            CAD, //CAD 	124 	Dollar 	100 Cents 	Kanada
            CDF, //CDF 	976 	Franc 	100 Centimes 	Demokratische Republik Kongo 	1997
            CHE, //CHE 	947 	WIR Euro 		Schweiz
            CHF, //CHF 	756 	Schweizer Franken 	100 Rappen 	Schweiz, Liechtenstein
            CHW, //CHW 	948 	WIR Franc 		Schweiz 	2004
            CLF, //CLF 	990 	Unidades de fomento 		Chile
            CLP, //CLP 	152 	Peso 	100 Centavos 	1975
            CNY, //CNY 	156 	Renminbi Yuan 	10 Jiao = 100 Fen 	Volksrepublik China
            COP, //COP 	170 	Peso 	100 Centavos 	Kolumbien
            COU, //COU 	970 	Unidad de Valor Real
            CRC, //CRC 	188 	Colón 	100 Céntimos 	Costa Rica
            CUC, //CUC 		Peso Convertible 	100 Centavos 	Kuba
            CUP, //CUP 	192 	Peso 	100 Centavos 	Kuba
            CVE, //CVE 	132 	Escudo 	100 Centavos 	Kap Verde
            CZK, //CZK 	203 	Krone 	100 Haleru 	Tschechien 	1993
            DJF, //DJF 	262 	Franc 	100 Centimes 	Dschibuti
            DKK, //DKK 	208 	Krone 	100 Øre 	Dänemark, Grönland
            DOP, //DOP 	214 	Peso 	100 Centavos 	Dominikanische Republik
            DZD, //DZD 	012 	Dinar 	100 Centimes 	Algerien
            EEK, //EEK 	233 	Krone 	100 Senti 	Estland
            EGP, //EGP 	818 	Pfund 	100 Piasters 	Ägypten
            ERN, //ERN 	232 	Nakfa 	100 Cents 	Eritrea
            ETB, //ETB 	230 	Birr 	100 Cents 	Äthiopien
            EUR, //EUR 	978 	Euro 	100 Cent 	Europäische Währungsunion (Belgien, Deutschland, Finnland, Frankreich, Griechenland, Irland, Italien, Luxemburg, Malta ab 01.01.2008, Niederlande, Österreich, Portugal, Slowakei ab 01.01.2009, Slowenien ab 01.01.2007, Spanien, Zypern ab 01.01.2008, Andorra, Kosovo, Monaco, Montenegro, San Marino, Vatikanstadt 	01.01.2002 (Buchwährung: 01.01.1999)
            FJD, //FJD 	242 	Dollar 	100 Cents 	Fidschi
            FKP, //FKP 	238 	Pfund 	100 Pence 	Falklandinseln
            GBP, //GBP 	826 	Pfund 	100 Pence 	Vereinigtes Königreich
            GEL, //GEL 	981 	Lari 	100 Tetri 	Georgien
            GHS, //GHS 	936 	Ghana Cedi 	100 Pesewas 	Ghana 	01.07.2007
            GIP, //GIP 	292 	Pfund 	100 Pence 	Gibraltar
            GMD, //GMD 	270 	Dalasi 	100 Bututs 	Gambia
            GNF, //GNF 	324 	Franc 	100 Centimes 	Guinea
            GTQ, //GTQ 	320 	Quetzal 	100 Centavos 	Guatemala
            GYD, //GYD 	328 	Dollar 	100 Cents 	Guyana
            HKD, //HKD 	344 	Dollar 	100 Cents 	Hongkong
            HNL, //HNL 	340 	Lempira 	100 Centavos 	Honduras
            HRK, //HRK 	191 	Kuna 	100 Lipa 	Kroatien
            HTG, //HTG 	332 	Gourde 	100 Centimes 	Haiti
            HUF, //HUF 	348 	Forint 	100 Fillér 	Ungarn
            IDR, //IDR 	360 	Rupiah 	100 Sen 	Indonesien
            ILS, //ILS 	376 	Schekel 	100 Agorot 	Israel, Palästinensische Autonomiegebiete 	1985
            INR, //INR 	356 	Rupie 	100 Paise 	Indien
            IQD, //IQD 	368 	Dinar 	1000 Fils 	Irak
            IRR, //IRR 	364 	Rial 	100 Dinars (nicht mehr in Verwendung) 	Iran
            ISK, //ISK 	352 	Krone 	100 Aurar 	Island 	1981
            JMD, //JMD 	388 	Dollar 	100 Cents 	Jamaika
            JOD, //JOD 	400 	Dinar 	100 Piaster 	Jordanien
            JPY, //JPY 	392 	Yen 	- (ehemals 100 Sen) 	Japan
            KES, //KES 	404 	Schilling 	100 Cents 	Kenia
            KGS, //KGS 	417 	Som 	100 Tyiyn 	Kirgisistan
            KHR, //KHR 	116 	Riel 	10 Karak = 100 Sen 	Kambodscha
            KMF, //KMF 	174 	Franc 	100 Centimes 	Komoren
            KPW, //KPW 	408 	Won 	100 Chon (nicht mehr in Verwendung) 	Nordkorea
            KRW, //KRW 	410 	Won 	100 Chon (nicht mehr in Verwendung) 	Südkorea
            KWD, //KWD 	414 	Dinar 	1000 Fils 	Kuwait
            KYD, //KYD 	136 	Dollar 	100 Cents 	Kaimaninseln
            KZT, //KZT 	398 	Tenge 	100 Tyin 	Kasachstan
            LAK, //LAK 	418 	Kip 	100 At 	Laos
            LBP, //LBP 	422 	Pfund 	100 Piastres 	Libanon
            LKR, //LKR 	144 	Rupie 	100 Cents 	Sri Lanka
            LRD, //LRD 	430 	Dollar 	100 Cents 	Liberia
            LSL, //LSL 	426 	Loti 	100 Lisente 	Lesotho
            LTL, //LTL 	440 	Litas 	100 Centas 	Litauen
            LVL, //LVL 	428 	Lats 	100 Santims 	Lettland
            LYD, //LYD 	434 	Dinar 	1000 Dirhams 	Libyen
            MAD, //MAD 	504 	Dirham 	100 Centimes 	Marokko, Westsahara
            MDL, //MDL 	498 	Leu 	100 Bani 	Moldawien
            MGA, //MGA 	969 	Ariary 	5 Iraimbilanja 	Madagaskar 	2005
            MKD, //MKD 	807 	Denar 	100 Deni 	Mazedonien 	1993
            MMK, //MMK 	104 	Kyat 	100 Pyas 	Myanmar
            MNT, //MNT 	496 	Tögrög 	100 Möngö 	Mongolei
            MOP, //MOP 	446 	Pataca 	100 Avos 	Macao
            MRO, //MRO 	478 	Ouguiya 	5 Khoums 	Mauretanien
            MUR, //MUR 	480 	Rupie 	100 Cents 	Mauritius
            MVR, //MVR 	462 	Rufiyaa 	100 Laari 	Malediven 	1981
            MWK, //MWK 	454 	Kwacha 	100 Tambala 	Malawi
            MXN, //MXN 	484 	Peso 	100 Centavos 	Mexiko 	1992
            MXV, //MXV 	979 	Mexican Unidad de Inversion (UDI)
            MYR, //MYR 	458 	Ringgit 	100 Sen 	Malaysia
            MZN, //MZN 	943 	Metical 	100 Centavos 	Mosambik 	01.07.2006
            NAD, //NAD 	516 	Dollar 	100 Cents 	Namibia
            NGN, //NGN 	566 	Naira 	100 Kobo 	Nigeria
            NIO, //NIO 	558 	Córdoba Oro 	100 Centavos 	Nicaragua 	1990
            NOK, //NOK 	578 	Krone 	100 Øre 	Norwegen
            NPR, //NPR 	524 	Rupie 	2 Mohur = 100 Paisa 	Nepal
            NZD, //NZD 	554 	Dollar 	100 Cents 	Neuseeland, Niue, Pitcairninseln
            OMR, //OMR 	512 	Rial 	1000 Baizas 	Oman
            PAB, //PAB 	590 	Balboa 	100 Centesimos 	Panama
            PEN, //PEN 	604 	Nuevo Sol 	100 Céntimos 	Peru 	1991
            PGK, //PGK 	598 	Kina 	100 Toea 	Papua-Neuguinea
            PHP, //PHP 	608 	Peso 	100 Centavos 	Philippinen
            PKR, //PKR 	586 	Rupie 	100 Paisa 	Pakistan
            PLN, //PLN 	985 	Złoty 	100 Groszy 	Polen 	1994
            PYG, //PYG 	600 	Guaraní 	100 Centimos 	Paraguay
            QAR, //QAR 	634 	Riyal 	100 Dirhams 	Katar
            RON, //RON 	946 	Leu 	100 Bani 	Rumänien 	2005
            RSD, //RSD 	941 	Dinar 	100 Para 	Serbien 	2006
            RUB, //RUB 	643 	Rubel 	100 Kopeken 	Russland 	1998
            RWF, //RWF 	646 	Franc 	100 Centimes 	Ruanda
            SAR, //SAR 	682 	Riyal 	20 Qirshes = 100 Hallalas 	Saudi-Arabien
            SBD, //SBD 	090 	Dollar 	100 Cents 	Salomonen
            SCR, //SCR 	690 	Rupie 	100 Cents 	Seychellen
            SDG, //SDG 	938 	Sudanesisches Pfund 	100 Piaster 	Sudan 	01.07.2007
            SEK, //SEK 	752 	Krone 	100 Öre 	Schweden
            SGD, //SGD 	702 	Dollar 	100 Cents 	Singapur
            SHP, //SHP 	654 	Pfund 	100 Pence 	St. Helena
            SLL, //SLL 	694 	Leone 	100 Cents 	Sierra Leone
            SOS, //SOS 	706 	Schilling 	100 Centesimi 	Somalia
            SRD, //SRD 	968 	Dollar 	100 Cents 	Suriname 	2004
            STD, //STD 	678 	Dobra 	100 Centimes 	São Tomé und Príncipe
            SVC, //SVC 	222 	Colón 	100 Centavos 	El Salvador
            SYP, //SYP 	760 	Pfund 	100 Piastres 	Syrien
            SZL, //SZL 	748 	Lilangeni 	100 Cents 	Swasiland
            THB, //THB 	764 	Baht 	100 Satang 	Thailand
            TJS, //TJS 	972 	Somoni 	100 Diram 	Tadschikistan 	06.11.2000
            TMT, //TMT 	934 	Manat 	100 Tenge 	Turkmenistan 	01.01.2009
            TND, //TND 	788 	Dinar 	1000 Millimes 	Tunesien
            TOP, //TOP 	776 	Paʻanga 	100 Seniti 	Tonga
            TRY, //TRY 	949 	Lira 	100 Kuruş 	Türkei, Nordzypern 	2009 (2005-2008 als "Neue" Lira)
            TTD, //TTD 	780 	Dollar 	100 Cents 	Trinidad und Tobago
            TWD, //TWD 	901 	Dollar 	100 Cents 	Republik China (Taiwan)
            TZS, //TZS 	834 	Schilling 	100 Cents 	Tansania
            UAH, //UAH 	980 	Hrywnja 	100 Kopeken 	Ukraine
            UGX, //UGX 	800 	Schilling 	100 Cents 	Uganda
            USD, //USD 	840 	Dollar 	100 Cents 	Vereinigte Staaten, Ecuador, El Salvador, Föderierte Staaten von Mikronesien, Marshallinseln, Osttimor, Palau sowie die britischen Überseegebiete Britische Jungferninseln und Turks- und Caicosinseln
            UYI, //UYI 	940 	Uruguay Peso en Unidades Indexadas 		Uruguay
            UYU, //UYU 	858 	Peso 	100 Centesimos 	1993
            UZS, //UZS 	860 	Soʻm 	100 Tiyin 	Usbekistan
            VEF, //VEF 	937 	Bolívar Fuerte 	100 Céntimos 	Venezuela 	01.01.2008
            VND, //VND 	704 	Đồng 	10 Hào = 100 Xu 	Vietnam
            VUV, //VUV 	548 	Vatu 	100 Centimes 	Vanuatu
            WST, //WST 	882 	Tala 	100 Sene 	Samoa
            XAF, //XAF 	950 	CFA-Franc (XAF) 	100 Centimes 	Zentralafrikanische Wirtschafts- und Währungsunion (Äquatorialguinea, Gabun, Kamerun, Republik Kongo, Tschad, Zentralafrikanische Republik)
            XCD, //XCD 	951 	Dollar 	100 Cents 	Ostkaribische Währungsunion (Antigua und Barbuda, Dominica, Grenada, St. Kitts und Nevis, St. Lucia, St. Vincent und die Grenadinen sowie die britischen Überseegebiete Anguilla und Montserrat)
            XOF, //XOF 	952 	CFA-Franc (XOF) 	100 Centimes 	Westafrikanische Wirtschafts- und Währungsunion (Benin, Burkina Faso, Elfenbeinküste, Guinea-Bissau, Mali, Niger, Senegal, Togo)
            XPF, //XPF 	953 	Franc 	- 	Französisch-Polynesien, Neukaledonien, Wallis und Futuna
            YER, //YER 	886 	Rial 	100 Fils 	Jemen
            ZAR, //ZAR 	710 	Rand 	100 Cents 	Südafrika
            ZMK, //ZMK 	894 	Kwacha 	100 Ngwee 	Sambia
            ZWR  //ZWR 	935 	Dollar 	100 Cents 	Simbabwe 	01.08.2008

        }

        private CURRENCY types;

        public CurrencyEnumHandler()
        {
            types = types.EUR;
        }

        @Override
        public int getMaxSize() {
            int max=0;

            for( CURRENCY val : CURRENCY.values() )
            {
                if( max < val.toString().length() )
                    max = val.toString().length();
            }

            return max;
        }

        @Override
        public boolean setValue(String val) {
            try {
                types  = CURRENCY.valueOf(val);
            } catch( IllegalArgumentException ex ) {
                return false;
            }
            return true;
        }

        @Override
        public String getValue() {
            return types.toString();
        }

        @Override
        public EnumHandler getNewOne() {
            return new CurrencyEnumHandler();
        }

        @Override
        public Vector<String> getPossibleValues() {

            Vector<String> res = new Vector<String>();

            for( CURRENCY val : CURRENCY.values() )
                res.add(val.toString());

            return res;
        }

    }
