/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import net.freeutils.tnef.RawInputStream;

public class TNEFUtils {
    static int[] CRC32_TABLE = new int[256];
    static byte[] COMPRESSED_RTF_PREBUF;

    public static int getU8(byte[] buf, int offset) {
        return buf[offset] & 0xFF;
    }

    public static int getU16(int b1, int b2) {
        return (b1 & 0xFF | (b2 & 0xFF) << 8) & 0xFFFF;
    }

    public static int getU16(byte[] buf, int offset) {
        return (buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8) & 0xFFFF;
    }

    public static long getU32(int b1, int b2, int b3, int b4) {
        return (long)(b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long getU32(byte[] buf, int offset) {
        return (long)(buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long getU64(byte[] buf, int offset) {
        return (TNEFUtils.getU32(buf, offset + 4) & 0xFFFFFFFFL) << 32 | TNEFUtils.getU32(buf, offset) & 0xFFFFFFFFL;
    }

    public static int attribute(int atp, int id) {
        return atp << 16 | id;
    }

    public static int attID(int att) {
        return att & 0xFFFF;
    }

    public static int attType(int att) {
        return att >> 16 & 0xFFFF;
    }

    public static int calculateChecksum(byte[] data) {
        return TNEFUtils.calculateChecksum(data, 0, data.length);
    }

    public static int calculateChecksum(byte[] data, int offset, int length) {
        long checksum = 0L;
        length += offset;
        for (int i = offset; i < length; ++i) {
            checksum += (long)(data[i] & 0xFF);
        }
        return (int)(checksum % 65536L);
    }

    public static int calculateChecksum(RawInputStream ris) throws IOException {
        int read;
        RawInputStream r = new RawInputStream(ris);
        int checksum = 0;
        byte[] buf = new byte[4096];
        while ((read = r.read(buf)) != -1) {
            checksum = (checksum + TNEFUtils.calculateChecksum(buf, 0, read)) % 65536;
        }
        return checksum;
    }

    public static String getConstName(Class cls, String constPrefix, long value) {
        Field[] fields = cls.getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith(constPrefix) || fields[i].getLong(null) != value) continue;
                return fields[i].getName();
            }
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        return "0x" + Long.toHexString(value);
    }

    public static String removeTerminatingNulls(String s) {
        int len;
        if (s == null) {
            return null;
        }
        for (len = s.length(); len > 0 && s.charAt(len - 1) == '\u0000'; --len) {
        }
        return len == s.length() ? s : s.substring(0, len);
    }

    public static String replace(String s, String search, String replace) {
        if (s == null || search == null || search.length() == 0) {
            return s;
        }
        if (replace == null) {
            replace = "";
        }
        int len = s.length();
        int slen = search.length();
        int rlen = replace.length();
        for (int ind = 0; ind < len && (ind = s.indexOf(search, ind)) > -1; ind += rlen) {
            s = s.substring(0, ind) + replace + s.substring(ind + slen);
        }
        return s;
    }

    public static String createString(byte[] bytes, int offset, int length) {
        try {
            return TNEFUtils.removeTerminatingNulls(new String(bytes, offset, length, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String createStringUnicode(byte[] bytes, int offset, int length) {
        try {
            return TNEFUtils.removeTerminatingNulls(new String(bytes, offset, length, "UTF-16LE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String toHexString(byte[] bytes) {
        return TNEFUtils.toHexString(bytes, 0, bytes != null ? bytes.length : 0, -1);
    }

    public static String toHexString(byte[] bytes, int max) {
        return TNEFUtils.toHexString(bytes, 0, bytes != null ? bytes.length : 0, max);
    }

    public static String toHexString(byte[] bytes, int offset, int len, int max) {
        int count = max > -1 ? Math.min(max, len) : len;
        StringBuffer s = new StringBuffer();
        s.append('[');
        if (bytes == null) {
            s.append(bytes);
        } else {
            for (int i = 0; i < count; ++i) {
                String b = Integer.toHexString(bytes[offset + i] & 0xFF).toUpperCase();
                if (b.length() == 1) {
                    s.append('0');
                }
                s.append(b);
            }
            if (count < len) {
                s.append("... (" + len + " bytes)");
            }
        }
        s.append(']');
        return s.toString();
    }

    public static boolean equals(byte[] src, int srcoffset, byte[] dst, int dstoffset, int length) {
        boolean equals = true;
        for (int i = 0; equals && i < length; ++i) {
            equals = src[srcoffset + i] == dst[dstoffset + i];
        }
        return equals;
    }

    public static boolean isTNEFMimeType(String mimeType) {
        return mimeType != null && ((mimeType = mimeType.toLowerCase()).startsWith("application/ms-tnef") || mimeType.startsWith("application/vnd.ms-tnef"));
    }

    public static byte[] toGUID(String guid) throws IllegalArgumentException {
        byte[] GUID = new byte[16];
        guid = TNEFUtils.replace(guid, "-", "");
        for (int i = 0; i < GUID.length; ++i) {
            try {
                GUID[i] = (byte)(Integer.parseInt(guid.substring(2 * i, 2 * i + 2), 16) & 0xFF);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid guid:" + guid + "(caused by: " + e + ")");
            }
        }
        return GUID;
    }

    public static int calculateCRC32(byte[] buf, int off, int len) {
        int c = 0;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            c = CRC32_TABLE[(c ^ buf[i]) & 0xFF] ^ c >>> 8;
        }
        return c;
    }

    public static byte[] decompressRTF(byte[] src) {
        byte[] dst;
        int in = 0;
        int out = 0;
        if (src == null || src.length < 16) {
            throw new IllegalArgumentException("Invalid compressed-RTF header");
        }
        int compressedSize = (int)TNEFUtils.getU32(src, in);
        int uncompressedSize = (int)TNEFUtils.getU32(src, in += 4);
        int magic = (int)TNEFUtils.getU32(src, in += 4);
        int crc32 = (int)TNEFUtils.getU32(src, in += 4);
        in += 4;
        if (compressedSize != src.length - 4) {
            throw new IllegalArgumentException("compressed-RTF data size mismatch");
        }
        if (crc32 != TNEFUtils.calculateCRC32(src, 16, src.length - 16)) {
            throw new IllegalArgumentException("compressed-RTF CRC32 failed");
        }
        if (magic == 1095517517) {
            dst = new byte[uncompressedSize];
            System.arraycopy(src, in, dst, out, uncompressedSize);
        } else if (magic == 1967544908) {
            dst = new byte[COMPRESSED_RTF_PREBUF.length + uncompressedSize];
            System.arraycopy(COMPRESSED_RTF_PREBUF, 0, dst, 0, COMPRESSED_RTF_PREBUF.length);
            out = COMPRESSED_RTF_PREBUF.length;
            int flagCount = 0;
            int flags = 0;
            while (out < dst.length) {
                int n = flags = flagCount++ % 8 == 0 ? TNEFUtils.getU8(src, in++) : flags >> 1;
                if ((flags & 1) == 1) {
                    int offset = TNEFUtils.getU8(src, in++);
                    int length = TNEFUtils.getU8(src, in++);
                    offset = offset << 4 | length >>> 4;
                    length = (length & 0xF) + 2;
                    if ((offset = out / 4096 * 4096 + offset) >= out) {
                        offset -= 4096;
                    }
                    int end = offset + length;
                    while (offset < end) {
                        dst[out++] = dst[offset++];
                    }
                    continue;
                }
                dst[out++] = src[in++];
            }
            src = dst;
            dst = new byte[uncompressedSize];
            System.arraycopy(src, COMPRESSED_RTF_PREBUF.length, dst, 0, uncompressedSize);
        } else {
            throw new IllegalArgumentException("Unknown compression type (magic number " + magic + ")");
        }
        return dst;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int j = 0; j < 8; ++j) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            TNEFUtils.CRC32_TABLE[i] = c;
        }
        try {
            String prebuf = "{\\rtf1\\ansi\\mac\\deff0\\deftab720{\\fonttbl;}{\\f0\\fnil \\froman \\fswiss \\fmodern \\fscript \\fdecor MS Sans SerifSymbolArialTimes New RomanCourier{\\colortbl\\red0\\green0\\blue0\n\r\\par \\pard\\plain\\f0\\fs20\\b\\i\\u\\tab\\tx";
            COMPRESSED_RTF_PREBUF = prebuf.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

