/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;

public class MAPIPropName {
    public static final int MNID_ID = 0;
    public static final int MNID_STRING = 1;
    byte[] GUID;
    int type;
    long ID;
    String name;
    int rawLength;

    public MAPIPropName(RawInputStream data) throws IOException {
        long startOffest = data.getPosition();
        this.GUID = data.readBytes(16);
        this.type = (int)data.readU32();
        if (this.type == 1) {
            int length = (int)data.readU32();
            this.name = data.readStringUnicode(length);
            if (length % 4 != 0) {
                data.skip(4 - length % 4);
            }
            this.rawLength += length;
        } else if (this.type == 0) {
            this.ID = data.readU32();
        }
        this.rawLength = (int)(data.getPosition() - startOffest);
    }

    public MAPIPropName(byte[] GUID, long ID) {
        this.GUID = GUID;
        this.type = 0;
        this.ID = ID;
    }

    public MAPIPropName(byte[] GUID, String name) {
        this.GUID = GUID;
        this.type = 1;
        this.name = name;
    }

    public byte[] getGUID() {
        return this.GUID;
    }

    public int getType() {
        return this.type;
    }

    public long getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer s = new StringBuffer().append("GUID=").append(TNEFUtils.toHexString(this.GUID)).append(" Name=").append(this.type == 1 ? this.name : "0x" + Long.toHexString(this.ID));
        return s.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MAPIPropName)) {
            return false;
        }
        MAPIPropName p = (MAPIPropName)o;
        return TNEFUtils.equals(this.GUID, 0, p.GUID, 0, this.GUID.length) && this.type == p.type && this.type == 1 ? this.name.equals(p.name) : (this.type == 0 ? this.ID == p.ID : true);
    }

    protected int getRawLength() {
        return this.rawLength;
    }
}

