/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.freeutils.tnef.Address;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.RendData;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.TRPAddress;

public class Attr {
    public static final int atpTriples = 0;
    public static final int atpString = 1;
    public static final int atpText = 2;
    public static final int atpDate = 3;
    public static final int atpShort = 4;
    public static final int atpLong = 5;
    public static final int atpByte = 6;
    public static final int atpWord = 7;
    public static final int atpDword = 8;
    public static final int atpMax = 9;
    public static final byte LVL_MESSAGE = 1;
    public static final byte LVL_ATTACHMENT = 2;
    public static final int attNull = 0;
    public static final int attFrom = 32768;
    public static final int attSubject = 32772;
    public static final int attDateSent = 32773;
    public static final int attDateRecd = 32774;
    public static final int attMessageStatus = 32775;
    public static final int attMessageClass = 32776;
    public static final int attMessageID = 32777;
    public static final int attParentID = 32778;
    public static final int attConversationID = 32779;
    public static final int attBody = 32780;
    public static final int attPriority = 32781;
    public static final int attAttachData = 32783;
    public static final int attAttachTitle = 32784;
    public static final int attAttachMetaFile = 32785;
    public static final int attAttachCreateDate = 32786;
    public static final int attAttachModifyDate = 32787;
    public static final int attDateModified = 32800;
    public static final int attAttachTransportFilename = 36865;
    public static final int attAttachRenddata = 36866;
    public static final int attMAPIProps = 36867;
    public static final int attRecipTable = 36868;
    public static final int attAttachment = 36869;
    public static final int attTnefVersion = 36870;
    public static final int attOemCodepage = 36871;
    public static final int attOriginalMessageClass = 6;
    public static final int attOwner = 0;
    public static final int attSentFor = 1;
    public static final int attDelegate = 2;
    public static final int attDateStart = 6;
    public static final int attDateEnd = 7;
    public static final int attAidOwner = 8;
    public static final int attRequestRes = 9;
    byte level;
    int type;
    int ID;
    int length;
    RawInputStream rawData;

    public Attr(byte level, int type, int ID, RawInputStream rawData) {
        this.level = level;
        this.type = type;
        this.ID = ID;
        this.rawData = rawData;
        this.length = rawData != null ? (int)rawData.getLength() : 0;
    }

    public byte getLevel() {
        return this.level;
    }

    public int getType() {
        return this.type;
    }

    public int getID() {
        return this.ID;
    }

    public int getLength() {
        return this.length;
    }

    public RawInputStream getRawData() {
        return this.rawData;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Attr:").append(" level=").append(this.getLevel()).append(" type=").append(TNEFUtils.getConstName(this.getClass(), "atp", this.getType())).append(" ID=").append(TNEFUtils.getConstName(this.getClass(), "att", this.getID())).append(" length=").append(this.getLength());
        s.append(" value=");
        try {
            Object o = this.getValue();
            if (o instanceof MAPIProps[]) {
                MAPIProps[] props = (MAPIProps[])o;
                for (int i = 0; i < props.length; ++i) {
                    for (int j = 0; j < props[i].getProps().length; ++j) {
                        s.append("\n  #").append(i).append(": ").append(props[i].getProps()[j]);
                    }
                }
            } else if (o instanceof MAPIProps) {
                MAPIProp[] props = ((MAPIProps)o).getProps();
                for (int i = 0; i < props.length; ++i) {
                    s.append("\n  ").append(props[i]);
                }
            } else {
                s.append(o);
            }
        }
        catch (IOException ioe) {
            s.append("INVALID VALUE: ").append(ioe);
        }
        return s.toString();
    }

    public Object getValue() throws IOException {
        Object o = null;
        RawInputStream ris = new RawInputStream(this.rawData);
        switch (this.ID) {
            case 36866: {
                o = new RendData(ris);
                break;
            }
            case 32768: {
                o = new TRPAddress(ris);
                break;
            }
            case 0: 
            case 1: {
                o = new Address(ris);
                break;
            }
            case 36868: {
                int count = (int)ris.readU32();
                MAPIProps[] recipients = new MAPIProps[count];
                for (int i = 0; i < count; ++i) {
                    recipients[i] = new MAPIProps(ris);
                }
                o = recipients;
                break;
            }
            case 36867: {
                o = new MAPIProps(ris);
            }
        }
        if (o == null) {
            switch (this.type) {
                case 6: {
                    o = ris;
                    break;
                }
                case 4: {
                    o = new Short((short)ris.readU16());
                    break;
                }
                case 8: {
                    o = new Long(ris.readU32());
                    break;
                }
                case 5: {
                    o = new Long(ris.readU32());
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    o = ris.readString(this.length);
                    break;
                }
                case 3: {
                    if (ris.getLength() < 14L) break;
                    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    cal.set(ris.readU16(), ris.readU16() - 1, ris.readU16(), ris.readU16(), ris.readU16(), ris.readU16());
                    cal.set(14, 0);
                    o = cal.getTime();
                    break;
                }
                case 0: {
                    o = new TRPAddress(ris);
                }
            }
        }
        return o;
    }

    public static Attr findAttr(List attributes, int ID) {
        Attr attr = null;
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            attr = (Attr)attributes.get(i);
            if (attr.getID() != ID) continue;
            return attr;
        }
        return null;
    }
}

