/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.mime;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.freeutils.tnef.Address;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.ContactHandler;
import net.freeutils.tnef.mime.RawDataSource;
import net.freeutils.tnef.mime.ReadReceiptHandler;
import net.freeutils.tnef.mime.TNEFMimeBodyPart;
import net.freeutils.tnef.mime.TNEFMimeMessage;

public class TNEFMime {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractTNEF(String mimeFilename, String tnefFilename) throws IOException, MessagingException {
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        FileInputStream fis = null;
        MimeMessage message = null;
        try {
            fis = new FileInputStream(mimeFilename);
            message = new MimeMessage(session, (InputStream)fis);
            boolean bl = TNEFMime.extractTNEF((Part)message, tnefFilename);
            return bl;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractTNEF(Part part, String tnefFilename) throws IOException, MessagingException {
        boolean extracted = false;
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                if (!TNEFMime.extractTNEF((Part)mp.getBodyPart(i), tnefFilename)) continue;
                extracted = true;
            }
        } else if (TNEFUtils.isTNEFMimeType(part.getContentType())) {
            InputStream in = part.getInputStream();
            BufferedOutputStream out = null;
            try {
                int b;
                out = new BufferedOutputStream(new FileOutputStream(tnefFilename));
                while ((b = in.read()) != -1) {
                    ((OutputStream)out).write(b);
                }
                extracted = true;
            }
            finally {
                in.close();
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        return extracted;
    }

    public static TNEFMimeMessage convert(Session session, TNEFInputStream in) throws IOException, MessagingException {
        return TNEFMime.convert(session, new Message(in));
    }

    public static TNEFMimeMessage convert(Session session, Message message) throws IOException, MessagingException {
        MimeBodyPart part;
        RawInputStream ris;
        String messageClassName;
        TNEFMimeMessage mime = new TNEFMimeMessage(session);
        Attr messageClass = message.getAttribute(32776);
        String string = messageClassName = messageClass == null ? "" : (String)messageClass.getValue();
        if (messageClassName.equalsIgnoreCase("IPM.Contact")) {
            Multipart mp = ContactHandler.convert(message);
            mime.setContent(mp);
            mime.saveChanges();
            return mime;
        }
        if (messageClassName.equalsIgnoreCase("IPM.Microsoft Mail.Read Receipt")) {
            Multipart mp = ReadReceiptHandler.convert(message);
            mime.setContent(mp);
            mime.saveChanges();
            return mime;
        }
        mime.setTNEFAttributes(message.getAttributes());
        Attr attr = Attr.findAttr(message.getAttributes(), 32768);
        if (attr != null) {
            Address address = (Address)attr.getValue();
            mime.setFrom((javax.mail.Address)new InternetAddress(address.getAddress(), address.getDisplayName()));
        }
        if ((attr = Attr.findAttr(message.getAttributes(), 32773)) != null) {
            mime.setSentDate((Date)attr.getValue());
        }
        if ((attr = Attr.findAttr(message.getAttributes(), 36868)) != null) {
            MAPIProps[] recipients = (MAPIProps[])attr.getValue();
            String name = null;
            String address = null;
            InternetAddress internetAddress = null;
            block5: for (int i = 0; i < recipients.length; ++i) {
                name = (String)recipients[i].getPropValue(12289);
                address = (String)recipients[i].getPropValue(12291);
                internetAddress = new InternetAddress(address, name);
                int type = (Integer)recipients[i].getPropValue(3093);
                switch (type) {
                    case 1: {
                        mime.addRecipient(Message.RecipientType.TO, (javax.mail.Address)internetAddress);
                        continue block5;
                    }
                    case 2: {
                        mime.addRecipient(Message.RecipientType.CC, (javax.mail.Address)internetAddress);
                        continue block5;
                    }
                    case 3: {
                        mime.addRecipient(Message.RecipientType.BCC, (javax.mail.Address)internetAddress);
                    }
                }
            }
        }
        if ((attr = Attr.findAttr(message.getAttributes(), 32772)) != null) {
            mime.setSubject((String)attr.getValue());
        }
        MimeMultipart mp = new MimeMultipart();
        attr = Attr.findAttr(message.getAttributes(), 32780);
        if (attr != null) {
            MimeBodyPart part2 = new MimeBodyPart();
            part2.setText((String)attr.getValue());
            mp.addBodyPart((BodyPart)part2);
        }
        if (message.getMAPIProps() != null && (ris = (RawInputStream)message.getMAPIProps().getPropValue(4105)) != null) {
            byte[] rtfBody = ris.toByteArray();
            part = new MimeBodyPart();
            part.setText(new String(TNEFUtils.decompressRTF(rtfBody)));
            part.setHeader("Content-Type", "text/rtf");
            mp.addBodyPart((BodyPart)part);
        }
        Iterator i = message.getAttachments().iterator();
        while (i.hasNext()) {
            Attachment attachment = (Attachment)i.next();
            part = new TNEFMimeBodyPart();
            if (attachment.getNestedMessage() == null) {
                part.setTNEFAttributes(attachment.getAttributes());
                String filename = attachment.getFilename();
                if (filename != null) {
                    part.setFileName(filename);
                }
                String contentType = null;
                if (attachment.getMAPIProps() != null) {
                    contentType = (String)attachment.getMAPIProps().getPropValue(14094);
                }
                if (contentType == null && filename != null) {
                    contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(filename);
                }
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                RawDataSource ds = new RawDataSource(attachment.getRawData(), contentType, filename);
                part.setDataHandler(new DataHandler((DataSource)ds));
                mp.addBodyPart((BodyPart)part);
                continue;
            }
            TNEFMimeMessage nestedMessage = TNEFMime.convert(session, attachment.getNestedMessage());
            part.setDataHandler(new DataHandler((Object)nestedMessage, "message/rfc822"));
            mp.addBodyPart((BodyPart)part);
        }
        mime.setContent((Multipart)mp);
        mime.saveChanges();
        return mime;
    }

    public static MimeMessage convert(Session session, MimeMessage message) throws MessagingException, IOException {
        message = (MimeMessage)TNEFMime.convert(session, (Part)message);
        message.saveChanges();
        return message;
    }

    public static Part convert(Session session, Part part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                Part convertedPart;
                BodyPart mpPart = mp.getBodyPart(i);
                if (mpPart == (convertedPart = TNEFMime.convert(session, (Part)mpPart))) continue;
                mp.removeBodyPart(i);
                TNEFMimeBodyPart newPart = new TNEFMimeBodyPart();
                newPart.setDataHandler(new DataHandler((Object)convertedPart, "message/rfc822"));
                mp.addBodyPart((BodyPart)newPart, i);
            }
            part.setContent(mp);
        } else if (TNEFUtils.isTNEFMimeType(part.getContentType())) {
            TNEFInputStream in = new TNEFInputStream(part.getInputStream());
            if (part instanceof MimeMessage) {
                MimeMessage mm = (MimeMessage)part;
                TNEFMimeMessage converted = TNEFMime.convert(session, in);
                mm.removeHeader("Content-Type");
                mm.removeHeader("Content-Transfer-Encoding");
                mm.removeHeader("Content-Disposition");
                mm.setContent(converted.getContent(), converted.getContentType());
            } else {
                part = TNEFMime.convert(session, in);
            }
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String options;
        String infile = null;
        String outfile = null;
        String usage = "\nUsage:\n\n" + "  java net.freeutils.tnef.mime.TNEFMime -[e|c] <infile> <outfile>\n" + "\nOptions:\n\n" + "  e Extract the TNEF attachment from a MIME file.\n" + "  c Convert a MIME file containing a TNEF attachment to a MIME file\n" + "    with a nested rfc822 message.\n" + "\nExamples:\n\n" + "  java net.freeutils.tnef.mime.TNEFMime -c c:\\temp\\1.mime c:\\temp\\2.mime\n" + "  java net.freeutils.tnef.mime.TNEFMime -e c:\\temp\\1.mime c:\\temp\\winmail.dat\n";
        if (args.length < 3) {
            System.out.println(usage);
            System.exit(1);
        }
        if ((options = args[0].toLowerCase()).startsWith("-") || options.startsWith("/")) {
            options = options.substring(1).trim();
        }
        infile = args[1];
        outfile = args[2];
        System.out.println("Processing file " + infile);
        Session session = Session.getInstance((Properties)new Properties());
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            if ("e".equals(options)) {
                TNEFMime.extractTNEF(infile, outfile);
            } else if ("c".equals(options)) {
                in = new FileInputStream(infile);
                MimeMessage mime = new MimeMessage(session, (InputStream)in);
                out = new FileOutputStream(outfile);
                mime = TNEFMime.convert(session, mime);
                mime.writeTo((OutputStream)out);
            } else {
                System.out.println("\nInvalid option: " + options);
                System.out.println(usage);
                System.exit(1);
            }
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

