/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.rtfparser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sourceforge.MSGViewer.rtfparser.ConvertCharset;
import net.sourceforge.MSGViewer.rtfparser.ParseException;
import net.sourceforge.MSGViewer.rtfparser.RTFGroup;
import net.sourceforge.MSGViewer.rtfparser.RTFParserConstants;
import net.sourceforge.MSGViewer.rtfparser.RTFParserTokenManager;
import net.sourceforge.MSGViewer.rtfparser.SimpleCharStream;
import net.sourceforge.MSGViewer.rtfparser.Token;

public class RTFParser
implements RTFParserConstants {
    RTFGroup current_group = null;
    List<RTFGroup> groups = new ArrayList<RTFGroup>();
    String characterSet = "";
    public RTFParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[3];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public List<RTFGroup> getGroups() {
        return this.groups;
    }

    public String getHTML() {
        StringBuilder sb = new StringBuilder();
        for (RTFGroup group : this.groups) {
            if (group.isEmptyText()) continue;
            String content = group.getTextContent();
            sb.append(content);
            if (!content.contains("<head>")) continue;
        }
        return sb.toString();
    }

    String codePage2Iso(String codepage) {
        if (codepage.equals("1252")) {
            return "iso-8859-1";
        }
        return codepage;
    }

    public final void parse() throws ParseException {
        this.group();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.group();
        }
        this.jj_consume_token(0);
    }

    public final void group() throws ParseException {
        block18: {
            this.group_start();
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block18;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.set_codepage();
                        continue block17;
                    }
                    case 16: {
                        this.command();
                        continue block17;
                    }
                    case 18: {
                        this.string_sequence();
                        continue block17;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        continue block17;
                    }
                    case 6: {
                        this.brace_open();
                        continue block17;
                    }
                    case 7: {
                        this.brace_close();
                        continue block17;
                    }
                    case 14: {
                        this.esc_special_char();
                        continue block17;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        this.current_group.addTextContent("\\");
                        continue block17;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        this.current_group.addTextContent("_");
                        continue block17;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        this.current_group.addTextContent("-");
                        continue block17;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        this.current_group.addTextContent("&nbsp;");
                        continue block17;
                    }
                    case 11: {
                        this.group();
                        continue block17;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.group_end();
    }

    public final void esc_special_char() throws ParseException {
        Token esc_char = null;
        esc_char = this.jj_consume_token(14);
        this.current_group.addTextContent(ConvertCharset.convertCharacter(this.characterSet, esc_char.image.substring(2)));
    }

    public final void set_codepage() throws ParseException {
        Token codepage = null;
        codepage = this.jj_consume_token(15);
        this.characterSet = codepage.image.substring(8);
    }

    public final void brace_open() throws ParseException {
        Token brace = null;
        brace = this.jj_consume_token(6);
        this.current_group.addTextContent("{");
    }

    public final void brace_close() throws ParseException {
        Token brace = null;
        brace = this.jj_consume_token(7);
        this.current_group.addTextContent("}");
    }

    public final void string_sequence() throws ParseException {
        Token string = null;
        string = this.jj_consume_token(18);
        this.current_group.addTextContent(string.image);
    }

    public final void command() throws ParseException {
        Token command = null;
        command = this.jj_consume_token(16);
        this.current_group.addCommand(command.image);
    }

    public final void group_start() throws ParseException {
        this.jj_consume_token(11);
        this.current_group = new RTFGroup();
        this.groups.add(this.current_group);
    }

    public final void group_end() throws ParseException {
        this.jj_consume_token(12);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{2048, 520128, 520128};
    }

    public RTFParser(InputStream stream) {
        this(stream, null);
    }

    public RTFParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new RTFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public RTFParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RTFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public RTFParser(RTFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(RTFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[19];
        for (i = 0; i < 19; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 3; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 19; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        RTFParser.jj_la1_0();
    }
}

