/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.rtfparser;

import java.util.ArrayList;
import java.util.List;

public class RTFGroup {
    private StringBuilder text_content;
    private List<String> commands = new ArrayList<String>();
    private String last_command = "";

    void addCommand(String command) {
        if (command.equals("\\par")) {
            this.addTextContent("\n");
        } else if (command.equals("\\tab")) {
            this.addTextContent("\t");
        } else {
            this.commands.add(command);
            this.last_command = command;
        }
    }

    public void addTextContent(String text) {
        if (this.text_content == null) {
            this.text_content = new StringBuilder();
        }
        if (this.last_command.startsWith("\\html")) {
            this.text_content.append(text);
        }
    }

    public boolean isEmpty() {
        if (this.text_content == null && this.commands.isEmpty()) {
            return true;
        }
        if (this.text_content.length() > 0) {
            return false;
        }
        return false;
    }

    public String getTextContent() {
        return this.text_content.toString();
    }

    public List<String> getCommands() {
        return this.commands;
    }

    boolean isEmptyText() {
        if (this.text_content == null) {
            return true;
        }
        return this.text_content.length() == 0;
    }
}

