/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.factory;

import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.MsgParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sourceforge.MSGViewer.factory.mbox.EMLWriterViaJavaMail;
import net.sourceforge.MSGViewer.factory.mbox.JavaMailParser;
import net.sourceforge.MSGViewer.factory.mbox.MBoxParser;
import net.sourceforge.MSGViewer.factory.mbox.MBoxWriterViaJavaMail;
import net.sourceforge.MSGViewer.factory.msg.MsgWriter;

public class MessageParserFactory {
    MsgParser msg_parser;
    MBoxParser mbox_parser;
    JavaMailParser jmail_parser;
    MBoxWriterViaJavaMail mbox_writer;
    EMLWriterViaJavaMail eml_writer;
    MsgWriter msg_writer;

    public Message parseMessage(File file) throws FileNotFoundException, IOException, Exception {
        int idx = file.getName().lastIndexOf(".");
        if (idx < 0) {
            throw new FileNotFoundException("Cannot identify file type");
        }
        String suffix = file.getName().substring(idx + 1).toLowerCase();
        if (suffix.equals("msg")) {
            return this.parseMsgFile(file);
        }
        if (suffix.equals("mbox")) {
            return this.paserJavaMailFile(file);
        }
        if (suffix.equals("eml")) {
            return this.paserJavaMailFile(file);
        }
        return null;
    }

    private Message parseMsgFile(File file) throws IOException {
        if (this.msg_parser == null) {
            this.msg_parser = new MsgParser();
        }
        return this.msg_parser.parseMsg(file);
    }

    private Message paserMBoxFile(File file) throws IOException, Exception {
        if (this.mbox_parser == null) {
            this.mbox_parser = new MBoxParser();
        }
        return this.mbox_parser.parse(file);
    }

    private Message paserJavaMailFile(File file) throws IOException, Exception {
        if (this.jmail_parser == null) {
            this.jmail_parser = new JavaMailParser();
        }
        return this.jmail_parser.parse(file);
    }

    public void saveMessage(Message msg, File file) throws FileNotFoundException, Exception {
        int idx = file.getName().lastIndexOf(".");
        if (idx < 0) {
            throw new FileNotFoundException("Cannot identify file type");
        }
        String suffix = file.getName().substring(idx + 1).toLowerCase();
        if (suffix.equals("msg")) {
            this.saveMsgFile(msg, file);
        } else if (suffix.equals("mbox")) {
            this.saveMBoxFile(msg, file);
        } else if (suffix.equals("eml")) {
            this.saveEMLFile(msg, file);
        }
    }

    private void saveMsgFile(Message msg, File file) throws FileNotFoundException, IOException {
        if (this.msg_writer == null) {
            this.msg_writer = new MsgWriter();
        }
        this.msg_writer.write(msg, new FileOutputStream(file));
    }

    private void saveMBoxFile(Message msg, File file) throws Exception {
        if (this.mbox_writer == null) {
            this.mbox_writer = new MBoxWriterViaJavaMail();
        }
        try {
            this.mbox_writer.write(msg, new FileOutputStream(file));
        }
        catch (Exception ex) {
            this.mbox_writer.close();
            throw ex;
        }
    }

    private void saveEMLFile(Message msg, File file) throws Exception {
        if (this.eml_writer == null) {
            this.eml_writer = new EMLWriterViaJavaMail();
        }
        try {
            this.eml_writer.write(msg, new FileOutputStream(file));
        }
        catch (Exception ex) {
            this.eml_writer.close();
            throw ex;
        }
    }
}

