/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.MSGNavigator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import net.sourceforge.MSGViewer.MSGNavigator.MSGNavigator;
import net.sourceforge.MSGViewer.factory.msg.lib.ByteConvert;
import net.sourceforge.MSGViewer.factory.msg.lib.MSTimeConvert;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class PropertyParser {
    private DocumentEntry entry;
    private boolean is_toplevel = false;
    private boolean is_attachment = false;
    private boolean is_reciepient = false;
    private int max_descr_lenght = 20;
    private ArrayList<PropertyTag> props = new ArrayList();

    public PropertyParser(DocumentEntry entry) throws IOException {
        this.entry = entry;
        for (String descr : MSGNavigator.props.values()) {
            if (descr.length() <= this.max_descr_lenght) continue;
            this.max_descr_lenght = descr.length();
        }
        this.parse();
    }

    final void parse() throws IOException {
        if (this.entry.getParent().getParent() == null) {
            this.is_toplevel = true;
        } else if (this.entry.getParent().getName().startsWith("__recip_version1.0")) {
            this.is_reciepient = true;
        } else if (this.entry.getParent().getName().startsWith("__attach_version1.0")) {
            this.is_attachment = true;
        }
        DocumentInputStream in = new DocumentInputStream(this.entry);
        byte[] bytes = new byte[this.entry.getSize()];
        int len = in.read(bytes);
        if (len != bytes.length) {
            throw new IOException("Not all Data read");
        }
        int offset = 8;
        if (this.is_toplevel) {
            offset += 4;
            offset += 4;
            offset += 4;
            offset += 4;
            offset += 8;
        }
        while (offset < bytes.length) {
            this.parsePropertyEntry(bytes, offset);
            offset += 16;
        }
    }

    private String formatByte(byte b) {
        if (b == 0) {
            return "__ ";
        }
        return String.format("%02X ", b);
    }

    private String formatByte0(byte b) {
        return String.format("%02X ", b);
    }

    private String formatByte0S(byte b) {
        return String.format("%02X", b);
    }

    private void parsePropertyEntry(byte[] bytes, int offset) {
        StringBuilder sb = new StringBuilder();
        String tagname = "";
        for (int i = offset + 3; i >= offset; --i) {
            sb.append(this.formatByte0S(bytes[i]));
            tagname = tagname + this.formatByte0S(bytes[i]);
        }
        sb.append(" ");
        if ((bytes[offset += 4] & 1) > 0) {
            sb.append("M");
        } else {
            sb.append("_");
        }
        if ((bytes[offset] & 2) > 0) {
            sb.append("R");
        } else {
            sb.append("_");
        }
        if ((bytes[offset] & 4) > 0) {
            sb.append("W");
        } else {
            sb.append("_");
        }
        sb.append(" VALUE: ");
        int value_start_offset = offset += 4;
        int i = 0;
        while (i < 8) {
            sb.append(this.formatByte0(bytes[offset]));
            ++i;
            ++offset;
        }
        sb.append(" ");
        String descr = StringUtils.defaultString((String)MSGNavigator.props.get(tagname.toLowerCase().substring(0, 4)));
        sb.append(StringUtils.rightPad((String)descr, (int)this.max_descr_lenght));
        String tagtype = tagname.toLowerCase().substring(4);
        if (tagtype.equals("001f")) {
            String res = "";
            for (int i2 = value_start_offset + 3; i2 >= value_start_offset; --i2) {
                res = res + this.formatByte0S(bytes[i2]);
            }
            int length = Integer.valueOf(res, 16);
            sb.append(" PtypString length: ");
            sb.append(String.valueOf(length - 2));
        } else if (tagtype.equals("0102")) {
            String res = "";
            for (int i3 = value_start_offset + 3; i3 >= value_start_offset; --i3) {
                res = res + this.formatByte0S(bytes[i3]);
            }
            int length = Integer.valueOf(res, 16);
            sb.append(" PtypBinary length: ");
            sb.append(String.valueOf(length));
        } else if (tagtype.equals("0040")) {
            sb.append(" PtypTime ");
            long time = ByteConvert.convertByteArrayToLong(bytes, value_start_offset);
            Date date = new Date(MSTimeConvert.PtypeTime2Millis(time));
            sb.append(date.toString());
        } else if (tagtype.equals("000b")) {
            sb.append(" boolean");
        } else if (tagtype.equals("0003")) {
            String res = "";
            for (int i4 = value_start_offset + 3; i4 >= value_start_offset; --i4) {
                res = res + this.formatByte0S(bytes[i4]);
            }
            int length = Long.valueOf(res, 16).intValue();
            sb.append(" PtypInteger32 value: ");
            sb.append(length);
        }
        this.props.add(new PropertyTag(tagname, sb.toString()));
    }

    public ArrayList<PropertyTag> getPropertyTags() {
        return this.props;
    }

    public static class PropertyTag {
        String descr;
        String tagname;

        public PropertyTag(String tagname, String descr) {
            this.tagname = tagname;
            this.descr = descr;
        }

        public String toString() {
            return this.descr;
        }
    }
}

