/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.utilities.StringUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JEditorPane;
import net.sourceforge.MSGViewer.LoadMessageInterface;
import org.apache.log4j.Logger;

public class EditorDropTarget
implements DropTargetListener {
    private static final Logger logger = Logger.getLogger((String)EditorDropTarget.class.getName());
    private final JEditorPane pane;
    private final DropTarget dropTarget;
    private boolean acceptableType;
    private boolean draggingFile;
    private Color feedbackColor;
    private final Color backgroundColor;
    private boolean changingBackground;
    LoadMessageInterface main_win;

    public EditorDropTarget(LoadMessageInterface main_win, JEditorPane pane) {
        this.pane = pane;
        this.main_win = main_win;
        this.feedbackColor = this.backgroundColor = pane.getBackground();
        this.dropTarget = new DropTarget(pane, 3, this, true, null);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        logger.debug((Object)"dragEnter");
        this.checkTransferType(dtde);
        boolean acceptedDrag = this.acceptOrRejectDrag(dtde);
        this.dragUnderFeedback(dtde, acceptedDrag);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        logger.debug((Object)"dragOver");
        boolean acceptedDrag = this.acceptOrRejectDrag(dtde);
        this.dragUnderFeedback(dtde, acceptedDrag);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        logger.debug((Object)"dropActionChanged");
        boolean acceptedDrag = this.acceptOrRejectDrag(dtde);
        this.dragUnderFeedback(dtde, acceptedDrag);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        logger.debug((Object)"dragExit");
        this.dragUnderFeedback(null, false);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        logger.debug((Object)"drop");
        if ((dtde.getDropAction() & 3) != 0) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable transferable = dtde.getTransferable();
            try {
                boolean result = false;
                result = this.draggingFile ? this.dropFile(transferable) : this.dropContent(transferable, dtde);
                dtde.dropComplete(result);
                logger.info((Object)("Drop completed, success: " + result));
            }
            catch (Exception e) {
                logger.info((Object)("Exception while handling drop " + e));
                dtde.rejectDrop();
            }
        } else {
            logger.info((Object)"Drop target rejected drop");
            dtde.dropComplete(false);
        }
    }

    protected boolean acceptOrRejectDrag(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        int sourceActions = dtde.getSourceActions();
        boolean acceptedDrag = false;
        logger.info((Object)("\tSource actions are " + sourceActions + ", drop action is " + dropAction));
        if (!this.acceptableType || (sourceActions & 3) == 0) {
            logger.info((Object)"Drop target rejecting drag");
            dtde.rejectDrag();
        } else if (!this.draggingFile && (sourceActions & 3) == 0) {
            logger.info((Object)"Drop target rejecting drag");
            dtde.rejectDrag();
        } else if ((dropAction & 3) == 0) {
            logger.info((Object)"Drop target offering COPY");
            dtde.acceptDrag(1);
            acceptedDrag = true;
        } else {
            logger.info((Object)"Drop target accepting drag");
            dtde.acceptDrag(dropAction);
            acceptedDrag = true;
        }
        return acceptedDrag;
    }

    protected void dragUnderFeedback(DropTargetDragEvent dtde, boolean acceptedDrag) {
        if (this.draggingFile) {
            Color newColor;
            Color color = newColor = dtde != null && acceptedDrag ? this.feedbackColor : this.backgroundColor;
            if (!newColor.equals(this.pane.getBackground())) {
                this.changingBackground = true;
                this.pane.setBackground(newColor);
                this.changingBackground = false;
                this.pane.repaint();
            }
        } else if (dtde != null && acceptedDrag) {
            Point location = dtde.getLocation();
            this.pane.getCaret().setVisible(true);
            this.pane.setCaretPosition(this.pane.viewToModel(location));
        } else {
            this.pane.getCaret().setVisible(false);
        }
    }

    protected void checkTransferType(DropTargetDragEvent dtde) {
        this.acceptableType = false;
        this.draggingFile = false;
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            this.acceptableType = true;
            this.draggingFile = true;
        } else if (dtde.isDataFlavorSupported(DataFlavor.plainTextFlavor) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.acceptableType = true;
        }
        logger.info((Object)("File type acceptable - " + this.acceptableType));
        logger.info((Object)("Dragging a file - " + this.draggingFile));
    }

    protected boolean dropFile(Transferable transferable) throws IOException, UnsupportedFlavorException, MalformedURLException {
        List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        File transferFile = (File)fileList.get(0);
        URL transferURL = transferFile.toURL();
        logger.info((Object)("File URL is " + transferURL));
        this.main_win.loadMessage(transferURL.getFile());
        return true;
    }

    protected boolean dropContent(Transferable transferable, DropTargetDropEvent dtde) {
        try {
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            DataFlavor selectedFlavor = null;
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                logger.info((Object)("Drop MIME type " + flavor.getMimeType() + " is available"));
                if (!flavor.equals(DataFlavor.plainTextFlavor) && !flavor.equals(DataFlavor.stringFlavor)) continue;
                selectedFlavor = flavor;
                break;
            }
            if (selectedFlavor == null) {
                return false;
            }
            logger.info((Object)("Selected flavor is " + selectedFlavor.getHumanPresentableName()));
            Object data = transferable.getTransferData(selectedFlavor);
            logger.info((Object)("Transfer data type is " + data.getClass().getName()));
            String insertData = null;
            if (data instanceof InputStream) {
                String charSet = selectedFlavor.getParameter("charset");
                InputStream is = (InputStream)data;
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                try {
                    insertData = new String(bytes, charSet);
                }
                catch (UnsupportedEncodingException e) {
                    insertData = new String(bytes);
                }
            } else if (data instanceof String) {
                insertData = (String)data;
            }
            if (insertData != null) {
                String[] files_to_open;
                logger.info((Object)("inserting text:" + insertData));
                for (String file_to_open : files_to_open = insertData.split("\n")) {
                    this.main_win.loadMessage(file_to_open);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)StringUtils.exceptionToString((Exception)e));
            return false;
        }
    }
}

