/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.CLIHelp;

import at.redeye.FrameWork.base.BaseModuleLauncher;
import java.util.ArrayList;
import net.sourceforge.MSGViewer.CLIHelp.CLIOption;

public class CLIHelp {
    private static final int LINE_LEN = 80;
    private final ArrayList<CLIOption> options = new ArrayList();
    private final BaseModuleLauncher module_launcher;

    public CLIHelp(BaseModuleLauncher module_launcher) {
        this.module_launcher = module_launcher;
    }

    public void add(CLIOption option) {
        this.options.add(option);
    }

    public void printHelpScreen() {
        int max_option_len = this.getMaxOptionLen();
        StringBuilder sb = new StringBuilder();
        for (CLIOption o : this.options) {
            o.buildShortHelpText(sb, max_option_len, 80);
            sb.append("\n");
            o.buildLongHelpText(sb, max_option_len + 1, 80);
        }
        System.out.println(this.module_launcher.root.getAppName() + " - " + this.module_launcher.root.getAppTitle());
        System.out.println("Version: " + this.module_launcher.getVersion() + "\n");
        System.out.println(sb);
    }

    public void printVersion() {
        System.out.println(this.module_launcher.root.getAppName() + " - " + this.module_launcher.root.getAppTitle());
        System.out.println("Version: " + this.module_launcher.getVersion() + "\n");
    }

    private int getMaxOptionLen() {
        int val = 0;
        for (CLIOption o : this.options) {
            val = Math.max(val, o.getName().length());
        }
        return val;
    }

    private int getMaxShortDescrLen() {
        int val = 0;
        for (CLIOption o : this.options) {
            Math.max(val, o.getShortDescription().length());
        }
        return val;
    }
}

