/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.factory.msg.entries;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.sourceforge.MSGViewer.factory.msg.PropTypes.PropPtypByteArray;
import net.sourceforge.MSGViewer.factory.msg.PropTypes.PropType;
import net.sourceforge.MSGViewer.factory.msg.entries.SubstGEntry;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.filesystem.DirectoryEntry;

public class RTFBodyTextEntry
extends SubstGEntry {
    public static final String NAME = "1009";
    private static final Logger logger = Logger.getLogger(RTFBodyTextEntry.class);
    byte[] value = null;

    public RTFBodyTextEntry(String text) {
        super(NAME, "0102");
        try {
            this.value = text.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
    }

    public RTFBodyTextEntry(byte[] bodyCompressesRTF) {
        super(NAME, "0102");
        this.value = bodyCompressesRTF;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public PropType getPropType() {
        PropPtypByteArray prop = new PropPtypByteArray(this.getTagName());
        prop.setValue(this.value);
        return prop;
    }

    @Override
    public void createEntry(DirectoryEntry dir) throws IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        this.createEntry(dir, this.value);
    }
}

