/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.factory.msg;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;

public class TopLevelPropertyStream {
    private static final Logger logger = Logger.getLogger((String)TopLevelPropertyStream.class.getName());
    public static final String NAME = "__properties_version1.0";
    private static final int HEADER_SIZE = 32;
    private DirectoryEntry root;
    private DocumentEntry property_entry;
    private byte[] bytes = null;

    public TopLevelPropertyStream(DirectoryEntry root) throws FileNotFoundException, IOException {
        this.root = root;
        try {
            this.property_entry = (DocumentEntry)root.getEntry(NAME);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.property_entry != null) {
            this.bytes = new byte[this.property_entry.getSize()];
            DocumentInputStream stream = new DocumentInputStream(this.property_entry);
            stream.read(this.bytes);
        }
    }

    public void save() throws IOException {
        int size = this.root.getEntryCount() * 16 + 32;
        this.bytes = new byte[size];
        int offset = 0;
        int i = 0;
        while (i < 8) {
            this.bytes[i] = 0;
            ++i;
            ++offset;
        }
        i = 0;
        while (i < 4) {
            this.bytes[offset] = 0;
            ++i;
            ++offset;
        }
        i = 0;
        while (i < 4) {
            this.bytes[offset] = 0;
            ++i;
            ++offset;
        }
        i = 0;
        while (i < 4) {
            this.bytes[offset] = 0;
            ++i;
            ++offset;
        }
        i = 0;
        while (i < 4) {
            this.bytes[offset] = 0;
            ++i;
            ++offset;
        }
        i = 0;
        while (i < 8) {
            this.bytes[offset] = 0;
            ++i;
            ++offset;
        }
        Iterator it = this.root.getEntries();
        while (it.hasNext()) {
            String name;
            Entry entry = (Entry)it.next();
            DocumentEntry de = null;
            if (entry.isDocumentEntry()) {
                de = (DocumentEntry)entry;
            }
            if ((name = entry.getName()).equals(NAME)) continue;
            String tagname = "";
            if (name.startsWith("__substg1.0_")) {
                tagname = name.substring(12);
            }
            String tagtype = tagname.substring(4).toLowerCase();
            this.bytes[offset++] = Integer.valueOf(tagname.substring(6), 16).byteValue();
            this.bytes[offset++] = Integer.valueOf(tagname.substring(4, 6), 16).byteValue();
            this.bytes[offset++] = Integer.valueOf(tagname.substring(2, 4), 16).byteValue();
            this.bytes[offset++] = Integer.valueOf(tagname.substring(0, 2), 16).byteValue();
            this.bytes[offset] = 6;
            offset += 4;
            if (tagtype.equals("001f")) {
                String lenght_str = String.format("%08x", de.getSize() + 2);
                this.bytes[offset++] = Integer.valueOf(lenght_str.substring(6), 16).byteValue();
                this.bytes[offset++] = Integer.valueOf(lenght_str.substring(4, 6), 16).byteValue();
                this.bytes[offset++] = Integer.valueOf(lenght_str.substring(2, 4), 16).byteValue();
                this.bytes[offset++] = Integer.valueOf(lenght_str.substring(0, 2), 16).byteValue();
            }
            offset += 4;
        }
        try {
            this.property_entry = (DocumentEntry)this.root.getEntry(NAME);
            this.property_entry.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.property_entry = this.root.createDocument(NAME, (InputStream)new ByteArrayInputStream(this.bytes));
    }

    public void delete(Entry entry) throws IOException {
        if (entry.getName().equals(NAME)) {
            throw new RuntimeException("deleting __properties_version1.0 is not allowed!");
        }
        if (entry.isDirectoryEntry()) {
            throw new RuntimeException("deleting directories not supported yet");
        }
        if (entry.getName().startsWith("__substg_version1.0")) {
            throw new RuntimeException("unly __substg entries are supported yet");
        }
        boolean found = false;
        for (int offset = 32; offset < this.bytes.length; offset += 16) {
            String tagname = "";
            for (int i = offset + 3; i >= offset; --i) {
                tagname = tagname + this.formatByte0S(this.bytes[i]);
            }
            if (!("__substg1.0_" + tagname).equals(entry.getName())) continue;
            if (!entry.delete()) {
                throw new RuntimeException("cannot delete entry");
            }
            byte[] new_bytes = new byte[this.bytes.length - 16];
            System.arraycopy(this.bytes, 0, new_bytes, 0, offset);
            System.arraycopy(this.bytes, offset + 16, new_bytes, offset, new_bytes.length - offset);
            this.bytes = new_bytes;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("entry not found");
        }
        try {
            this.property_entry = (DocumentEntry)this.root.getEntry(NAME);
            this.property_entry.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.property_entry = this.root.createDocument(NAME, (InputStream)new ByteArrayInputStream(this.bytes));
    }

    private String formatByte0S(byte b) {
        return String.format("%02X", b);
    }

    public void update(DocumentEntry entry) throws IOException {
        if (entry.getName().equals(NAME)) {
            throw new RuntimeException("deleting __properties_version1.0 is not allowed!");
        }
        if (entry.isDirectoryEntry()) {
            throw new RuntimeException("deleting directories not supported yet");
        }
        if (entry.getName().startsWith("__substg_version1.0")) {
            throw new RuntimeException("unly __substg entries are supported yet");
        }
        boolean found = false;
        for (int offset = 32; offset < this.bytes.length; offset += 16) {
            String tagname = "";
            for (int i = offset + 3; i >= offset; --i) {
                tagname = tagname + this.formatByte0S(this.bytes[i]);
            }
            if (!("__substg1.0_" + tagname).equals(entry.getName())) continue;
            String tagtype = tagname.toLowerCase().substring(4);
            int voffset = offset + 8;
            if (tagtype.equals("001f")) {
                String lenght_str = String.format("%08x", entry.getSize() + 2);
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(6), 16).byteValue();
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(4, 6), 16).byteValue();
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(2, 4), 16).byteValue();
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(0, 2), 16).byteValue();
            } else if (tagtype.equals("0102")) {
                String lenght_str = String.format("%08x", entry.getSize() + 2);
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(6), 16).byteValue();
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(4, 6), 16).byteValue();
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(2, 4), 16).byteValue();
                this.bytes[voffset++] = Integer.valueOf(lenght_str.substring(0, 2), 16).byteValue();
            }
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("entry not found");
        }
        try {
            this.property_entry = (DocumentEntry)this.root.getEntry(NAME);
            this.property_entry.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.property_entry = this.root.createDocument(NAME, (InputStream)new ByteArrayInputStream(this.bytes));
    }
}

