/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.factory.mbox.headers;

import at.redeye.FrameWork.utilities.StringUtils;
import com.auxilii.msgparser.Message;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.MSGViewer.factory.mbox.MailAddress;
import net.sourceforge.MSGViewer.factory.mbox.headers.HeaderParser;
import org.apache.log4j.Logger;

public abstract class EmailHeader
extends HeaderParser {
    private static final Logger logger = Logger.getLogger(EmailHeader.class);

    public EmailHeader(String header) {
        super(header);
    }

    @Override
    public void parse(Message msg, String line) {
        logger.debug((Object)("line: " + line));
        List<MailAddress> emails = EmailHeader.splitAttendees(line);
        if (emails != null && !emails.isEmpty()) {
            this.assign(msg, emails);
        }
    }

    public abstract void assign(Message var1, List<MailAddress> var2);

    public static List<MailAddress> splitAttendees(String text) {
        String[] parts = text.split(",");
        ArrayList<MailAddress> addresses = new ArrayList<MailAddress>();
        for (String part : parts) {
            MailAddress addr = new MailAddress();
            int start = part.indexOf("<");
            int end = part.indexOf(">");
            if (start >= 0 && end >= 0) {
                addr.setEmail(part.substring(start + 1, end));
                addr.setDisplayName(StringUtils.strip((String)part.substring(0, start).trim(), (String)"\""));
            } else {
                addr.setEmail(part);
            }
            if (!addr.getEmail().contains("@")) continue;
            addresses.add(addr);
        }
        if (addresses.isEmpty()) {
            return null;
        }
        return addresses;
    }
}

