/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.base.AutoMBox;
import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.BaseDialogBase;
import at.redeye.FrameWork.base.Root;
import at.redeye.FrameWork.base.Setup;
import at.redeye.FrameWork.base.imagestorage.ImageUtils;
import at.redeye.FrameWork.utilities.StringUtils;
import at.redeye.Plugins.ShellExec.ShellExec;
import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.attachment.Attachment;
import com.auxilii.msgparser.attachment.FileAttachment;
import com.auxilii.msgparser.attachment.MsgAttachment;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.sourceforge.MSGViewer.AppConfigDefinitions;
import net.sourceforge.MSGViewer.MainWin;
import net.sourceforge.MSGViewer.OpenNewMailInterface;
import net.sourceforge.MSGViewer.PrepareImages;
import net.sourceforge.MSGViewer.ViewerHelper;
import net.sourceforge.MSGViewer.factory.MessageParserFactory;

public class ViewerPanel
extends JPanel
implements HyperlinkListener {
    private String bodyText = null;
    private Message message;
    private ViewerHelper helper = null;
    private Root root = null;
    private String file_name;
    private OpenNewMailInterface open_new_mail_handler = null;
    private BaseDialogBase parent = null;
    private MessageParserFactory parser_factory = new MessageParserFactory();
    private int wating_thread_pool_counter = 0;
    private URL lastUrl = null;
    private JCheckBox JCBfix;
    private JEditorPane body;
    private JEditorPane header;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRRTF;
    private JRadioButton jRText;
    private JSlider jSFontSize;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane;

    public ViewerPanel() {
        this.initComponents();
        this.header.addHyperlinkListener(this);
        this.body.addHyperlinkListener(this);
        this.JCBfix.setEnabled(this.jRText.isSelected());
    }

    public void setRoot(Root root, BaseDialogBase parent) {
        this.parent = parent;
        this.root = root;
        this.helper = new ViewerHelper(root);
        if (StringUtils.isYes((String)root.getSetup().getLocalConfig("RTFFormat", "yes"))) {
            this.jRRTF.setSelected(true);
            this.jRText.setSelected(false);
        } else {
            this.jRRTF.setSelected(false);
            this.jRText.setSelected(true);
        }
        this.JCBfix.setSelected(StringUtils.isYes((String)root.getSetup().getLocalConfig("FixedFont", "no")));
        this.JCBfix.setEnabled(this.jRText.isSelected());
        this.jSplitPane.setDividerLocation(Integer.parseInt(root.getSetup().getLocalConfig("DividerLocation", "150")));
    }

    public void loadFile(String file_name) {
        this.file_name = file_name;
        this.parse(file_name);
    }

    public void setopenNewMailInterface(OpenNewMailInterface open_new_mail_handler) {
        this.open_new_mail_handler = open_new_mail_handler;
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.header = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.body = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.jRRTF = new JRadioButton();
        this.jRText = new JRadioButton();
        this.JCBfix = new JCheckBox();
        this.jSFontSize = new JSlider();
        this.jLabel1 = new JLabel();
        this.jSplitPane.setOrientation(0);
        this.header.setEditable(false);
        this.jScrollPane1.setViewportView(this.header);
        this.jSplitPane.setTopComponent(this.jScrollPane1);
        this.body.setEditable(false);
        this.jScrollPane2.setViewportView(this.body);
        this.jRRTF.setText("RTF");
        this.jRRTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.jRRTFActionPerformed(evt);
            }
        });
        this.jRText.setText("Text");
        this.jRText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.jRTextActionPerformed(evt);
            }
        });
        this.JCBfix.setText("Fixed Font");
        this.JCBfix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.JCBfixActionPerformed(evt);
            }
        });
        this.jSFontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ViewerPanel.this.jSFontSizeStateChanged(evt);
            }
        });
        this.jLabel1.setText("Fontsize");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRRTF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.JCBfix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSFontSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(0, 95, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRRTF).addComponent(this.jRText).addComponent(this.JCBfix)).addComponent(this.jSFontSize, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING))));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 276, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        this.jSplitPane.setRightComponent(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 339, Short.MAX_VALUE));
    }

    private void jSFontSizeStateChanged(ChangeEvent evt) {
        EditorKit editor = this.body.getEditorKit();
        if (editor instanceof HTMLEditorKit) {
            Source source = new Source((CharSequence)this.body.getText());
            source.fullSequentialParse();
            ArrayList<String> tags = new ArrayList<String>();
            for (StartTag tag : source.getAllStartTags()) {
                tags.add(tag.getName());
            }
            HTMLEditorKit html_editor = (HTMLEditorKit)editor;
            System.out.println("Value: " + this.jSFontSize.getValue());
            StyleSheet sheet = html_editor.getStyleSheet();
            String rule = "{ font-size: " + this.jSFontSize.getValue() + "pt; }";
            StringBuilder sb = new StringBuilder();
            for (String tag : tags) {
                sb.append(tag);
                sb.append(rule);
            }
            sheet.addRule(sb.toString());
            String text = this.body.getText();
            this.body.setDocument(html_editor.createDefaultDocument());
            this.body.setText(text);
            this.body.setCaretPosition(0);
        } else if (this.bodyText != null) {
            this.bodyText = this.bodyText.replaceAll("(\\\\fs)([0-9]+)", "$1" + this.jSFontSize.getValue() * 2);
            System.out.println(this.bodyText);
            this.body.setText(this.bodyText);
            this.body.setCaretPosition(0);
        }
    }

    private void jRRTFActionPerformed(ActionEvent evt) {
        this.jRText.setSelected(!this.jRRTF.isSelected());
        this.JCBfix.setEnabled(this.jRText.isSelected());
        this.updateBody();
    }

    private void jRTextActionPerformed(ActionEvent evt) {
        this.jRRTF.setSelected(!this.jRText.isSelected());
        this.JCBfix.setEnabled(this.jRText.isSelected());
        this.updateBody();
    }

    private void JCBfixActionPerformed(ActionEvent evt) {
        this.updateBody();
    }

    private void updateBody() {
        if (this.message == null) {
            return;
        }
        if (this.jRRTF.isSelected() && this.message.getBodyRTF() != null && !this.message.getBodyRTF().isEmpty()) {
            if (this.message.getBodyRTF() == null) {
                return;
            }
            if (this.message.getBodyRTF().contains("\\fromhtml")) {
                AutoMBox am = new AutoMBox(MainWin.class.getName()){

                    public void do_stuff() throws Exception {
                        ViewerPanel.this.body.setContentType("text/html");
                        this.logger.info((Object)"extracting HTML data from RTF Code");
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("\n" + StringUtils.addLineNumbers((String)ViewerPanel.this.message.getBodyRTF())));
                        }
                        ViewerPanel.this.bodyText = ViewerPanel.this.helper.extractHTMLFromRTF(ViewerPanel.this.message.getBodyRTF(), ViewerPanel.this.message);
                        this.logger.trace((Object)ViewerPanel.this.bodyText);
                        ViewerPanel.this.body.setText(ViewerPanel.this.bodyText);
                    }
                };
                if (am.isFailed()) {
                    this.body.setContentType("text/rtf");
                    this.bodyText = this.message.getBodyRTF();
                    this.body.setText(this.bodyText);
                }
            } else if (this.message.getBodyRTF().contains("\\purehtml")) {
                String html;
                this.body.setContentType("text/html");
                PrepareImages prep_images = new PrepareImages(this.helper.getTmpDir().getPath(), this.message);
                this.bodyText = html = prep_images.prepareImages(new StringBuilder(ViewerHelper.stripMetaTags(this.message.getBodyRTF()))).toString();
                this.body.setText(html);
            } else {
                this.body.setContentType("text/rtf");
                this.bodyText = this.message.getBodyRTF();
                this.body.setText(this.message.getBodyRTF());
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            String font = "Dialog,sans-serif;font-size:10px;";
            if (this.JCBfix.isSelected()) {
                font = "Courier New;font-size:10px;";
            }
            sb.append("<pre style=\"font-family:" + font + "\">");
            String text = this.message.getBodyText();
            sb.append(ViewerHelper.prepareText(text));
            sb.append("</pre>");
            sb.append("</body></html>");
            this.body.setContentType("text/html");
            this.bodyText = sb.toString();
            this.body.setText(this.bodyText);
        }
        this.body.setCaretPosition(0);
    }

    @Override
    public void hyperlinkUpdate(final HyperlinkEvent e) {
        new AutoMBox(MainWin.class.getName()){

            public void do_stuff() throws Exception {
                if (ViewerPanel.this.message == null) {
                    return;
                }
                if (!e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                        ViewerPanel.this.lastUrl = e.getURL();
                    } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                        ViewerPanel.this.lastUrl = null;
                    }
                    return;
                }
                ViewerPanel.this.lastUrl = null;
                ViewerPanel.this.openUrl(e.getURL());
            }
        };
    }

    public void openUrl(URL url) throws IOException {
        BaseDialog.logger.info((Object)url);
        String protocoll = url.getProtocol();
        if (!protocoll.equals("file")) {
            if (Setup.is_win_system()) {
                BaseDialog.logger.info((Object)("opening: " + url));
                ShellExec shell = new ShellExec();
                int ret = shell.execute(url.toString());
                BaseDialog.logger.debug((Object)("shell exec returned: " + ret));
            } else {
                String open_command = this.helper.getOpenCommand();
                String command = open_command + " \"" + url.toString() + "\"";
                BaseDialog.logger.info((Object)command);
                String[] command_array = new String[]{open_command, url.toString()};
                Process process = Runtime.getRuntime().exec(command_array);
            }
            return;
        }
        File content = this.helper.extractUrl(url, this.message);
        if (content == null) {
            content = new File(url.getFile());
        }
        if (ViewerHelper.is_mail_message(content.toString())) {
            if (this.open_new_mail_handler != null) {
                this.open_new_mail_handler.openMail(this.root, content.toString());
            }
        } else if (Setup.is_win_system() && this.root.getPlugin("ShellExec") != null) {
            BaseDialog.logger.info((Object)("opening: " + content.getPath()));
            ShellExec shell = new ShellExec();
            int ret = shell.execute(content.getPath());
            BaseDialog.logger.debug((Object)("shell exec returned: " + ret));
        } else {
            String open_command = this.helper.getOpenCommand();
            String command = open_command + " \"" + content.getPath() + "\"";
            BaseDialog.logger.info((Object)command);
            String[] command_array = new String[]{open_command, content.getPath()};
            Process process = Runtime.getRuntime().exec(command_array);
        }
    }

    public void parse(final String file_name) {
        if (file_name == null) {
            return;
        }
        this.file_name = file_name;
        this.parent.setWaitCursor();
        new AutoMBox(MainWin.class.getName()){

            public void do_stuff() throws Exception {
                ViewerPanel.this.parse_int(file_name);
            }
        };
        this.parent.setNormalCursor();
    }

    void cleanUp() {
        if (this.message == null) {
            return;
        }
        this.message = null;
    }

    void parse_int(final String file_name) throws IOException, FileNotFoundException, Exception {
        int max_width;
        this.cleanUp();
        final ExecutorService thread_pool = Executors.newCachedThreadPool();
        this.wating_thread_pool_counter = 0;
        File file = new File(file_name);
        if (!file.exists()) {
            throw new FileNotFoundException(this.parent.MlM(String.format("File %s not found", file_name)));
        }
        this.message = this.parser_factory.parseMessage(file);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<body style=\"\">");
        sb.append("<b>");
        if (this.message.getSubject() != null) {
            sb.append(this.message.getSubject());
        }
        sb.append("</b>");
        sb.append("<br/>");
        BaseDialog.logger.info((Object)("Message From:" + this.message.getFromName() + "\n To:" + this.message.getToName() + "\n Email: " + this.message.getFromEmail()));
        if (this.message.getFromEmail() != null || this.message.getFromName() != null) {
            if (this.message.getFromEmail() == null) {
                sb.append(this.parent.MlM("From:") + this.message.getFromName());
            } else if (this.message.getFromName() == null) {
                sb.append("<a href=\"mailto:");
                sb.append(this.message.getFromEmail());
                sb.append("\">");
                sb.append(this.message.getFromEmail());
            } else {
                sb.append("<a href=\"mailto:");
                sb.append(this.message.getFromEmail());
                sb.append("\">");
                sb.append(this.message.getFromName());
            }
        }
        if (this.message.getFromEmail() != null && this.message.getFromEmail().contains("@")) {
            sb.append(" [");
            sb.append(this.message.getFromEmail());
            sb.append("]");
        }
        sb.append("</a>");
        sb.append("<br/>");
        if (this.message.getDate() != null) {
            sb.append(this.parent.MlM("Date"));
            sb.append(": ");
            sb.append(DateFormat.getDateTimeInstance().format(this.message.getDate()));
            sb.append("<br/>");
        }
        if (this.message.getToEmail() != null || this.message.getToName() != null) {
            sb.append(this.parent.MlM("To:"));
            sb.append(" ");
        }
        if (this.message.getToName() != null) {
            BaseDialog.logger.info((Object)("toName: " + this.message.getToName()));
            sb.append(this.message.getToName());
        }
        if (this.message.getToEmail() != null && this.message.getToEmail().contains("@")) {
            if (this.message.getToName() != null) {
                sb.append(" [");
            }
            sb.append(this.message.getToEmail());
            if (this.message.getToName() != null) {
                sb.append("]");
            }
        }
        sb.append("<br>");
        List attachments = this.message.getAttachments();
        final int max_height = max_width = Integer.parseInt(this.root.getSetup().getLocalConfig(AppConfigDefinitions.IconSize));
        for (Attachment att : attachments) {
            if (att instanceof FileAttachment) {
                final FileAttachment fatt = (FileAttachment)att;
                String encoded_file_name = URLEncoder.encode(fatt.toString(), "utf-8");
                sb.append("<a href=\"file://");
                sb.append(encoded_file_name);
                sb.append("\">");
                String mime_type = fatt.getMimeTag();
                BaseDialog.logger.info((Object)("<a href=\"file://" + encoded_file_name + "\"> " + mime_type));
                if (mime_type != null) {
                    if (ViewerHelper.is_image_mime_type(mime_type) && fatt.getSize() < 0x200000L) {
                        File message_dir = this.helper.getTmpDir();
                        if (!message_dir.isDirectory() && !message_dir.mkdirs()) {
                            BaseDialog.logger.error((Object)("Cannot create tmp dir: " + message_dir.getPath()));
                        } else {
                            final File content = new File(message_dir + "/" + fatt.toString());
                            if (!content.exists()) {
                                ++this.wating_thread_pool_counter;
                                thread_pool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileOutputStream fout = new FileOutputStream(content);
                                            fout.write(fatt.getData());
                                            fout.close();
                                        }
                                        catch (IOException ex) {
                                            BaseDialog.logger.error((Object)ex, (Throwable)ex);
                                        }
                                        ViewerPanel.this.wating_thread_pool_counter--;
                                    }
                                });
                                ++this.wating_thread_pool_counter;
                                thread_pool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            ImageIcon icon = ImageUtils.loadScaledImageIcon((byte[])fatt.getData(), (String)PrepareImages.getFileName(fatt), (int)max_width, (int)max_height);
                                            File file_small = new File(content.getAbsolutePath() + "-small.jpg");
                                            BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                                            Graphics2D g2 = bi.createGraphics();
                                            g2.drawImage(icon.getImage(), 0, 0, null);
                                            g2.dispose();
                                            ImageIO.write((RenderedImage)bi, "jpg", file_small);
                                        }
                                        catch (IOException ex) {
                                            BaseDialog.logger.error((Object)ex, (Throwable)ex);
                                        }
                                        ViewerPanel.this.wating_thread_pool_counter--;
                                    }
                                });
                            }
                            String extra = "/";
                            if (Setup.is_win_system()) {
                                extra = "";
                            }
                            System.out.println(extra + content.getAbsolutePath() + "-small.jpg");
                            sb.append("<img border=0 src=\"file:/" + extra + content.getAbsolutePath() + "-small.jpg\"/> ");
                        }
                    }
                }
                if (ViewerHelper.is_mail_message(fatt.getFilename(), fatt.getMimeTag())) {
                    sb.append("<img border=0 align=\"baseline\" src=\"file:");
                    sb.append(this.helper.getMailIconName(this.helper.getTmpDir()));
                    sb.append("\"/>");
                }
                if (!fatt.getFilename().isEmpty()) {
                    sb.append(fatt.getFilename());
                } else {
                    sb.append(fatt.toString());
                }
                sb.append("</a> ");
                continue;
            }
            if (att instanceof MsgAttachment) {
                MsgAttachment msgAtt = (MsgAttachment)att;
                final Message msg = msgAtt.getMessage();
                File message_dir = this.helper.getTmpDir();
                if (!message_dir.isDirectory() && !message_dir.mkdirs()) {
                    BaseDialog.logger.error((Object)("Cannot create tmp dir: " + message_dir.getPath()));
                    continue;
                }
                final String sub_file_name = message_dir + "/" + msg.hashCode() + ".mbox";
                thread_pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        new AutoMBox(file_name){

                            public void do_stuff() throws Exception {
                                MessageParserFactory factory = new MessageParserFactory();
                                factory.saveMessage(msg, new File(sub_file_name));
                            }
                        };
                    }
                });
                sb.append("<a href=\"file://");
                sb.append(sub_file_name);
                sb.append("\">");
                sb.append("<img border=0 align=\"baseline\" src=\"file:");
                sb.append(this.helper.getMailIconName(this.helper.getTmpDir()));
                sb.append("\"/>");
                sb.append(msg.getSubject());
                sb.append("</a> &nbsp; ");
                continue;
            }
            BaseDialog.logger.error((Object)("unknown Attachment: " + att.toString() + " " + att.getClass().getName()));
        }
        sb.append("</body></html>");
        this.header.setContentType("text/html");
        if (this.wating_thread_pool_counter > 0) {
            this.updateBody();
            new AutoMBox(file_name){

                public void do_stuff() throws Exception {
                    thread_pool.shutdown();
                    if (ViewerPanel.this.wating_thread_pool_counter > 0) {
                        thread_pool.awaitTermination(1L, TimeUnit.DAYS);
                    }
                }
            };
            this.header.setText(sb.toString());
            this.header.setCaretPosition(0);
        } else {
            this.header.setText(sb.toString());
            this.header.setCaretPosition(0);
            this.updateBody();
        }
    }

    public void dispose() {
        this.root.getSetup().setLocalConfig("RTFFormat", this.jRRTF.isSelected() ? "yes" : "no");
        this.root.getSetup().setLocalConfig("FixedFont", this.JCBfix.isSelected() ? "yes" : "no");
        this.root.getSetup().setLocalConfig("DividerLocation", String.valueOf(this.jSplitPane.getDividerLocation()));
        this.helper.dispose();
    }

    public Message getMessage() {
        return this.message;
    }

    public void exportFile(File export_file) throws Exception {
        this.parser_factory.saveMessage(this.message, export_file);
    }

    public void exportFile(File file, Message message) throws FileNotFoundException, Exception {
        this.parser_factory.saveMessage(message, file);
    }

    public String getFileName() {
        return this.file_name;
    }

    public JEditorPane getHeaderPane() {
        return this.header;
    }

    public JEditorPane getBodyPane() {
        return this.body;
    }
}

