/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.BaseModuleLauncher;
import at.redeye.FrameWork.base.FrameWorkConfigDefinitions;
import at.redeye.FrameWork.base.LocalRoot;
import at.redeye.FrameWork.base.Setup;
import at.redeye.FrameWork.widgets.StartupWindow;
import net.sourceforge.MSGViewer.AppConfigDefinitions;
import net.sourceforge.MSGViewer.CLIFileConverter;
import net.sourceforge.MSGViewer.CLIHelpMSGViewer;
import net.sourceforge.MSGViewer.MBox2Msg;
import net.sourceforge.MSGViewer.MainDialog;
import net.sourceforge.MSGViewer.MainWin;
import net.sourceforge.MSGViewer.Msg2Eml;
import net.sourceforge.MSGViewer.Msg2MBox;
import net.sourceforge.MSGViewer.Plugins.msgparser.Plugin;
import net.sourceforge.MSGViewer.SingleWin;
import net.sourceforge.MSGViewer.Version;
import org.apache.log4j.Level;

public class ModuleLauncher
extends BaseModuleLauncher {
    MainDialog mainwin;

    public ModuleLauncher(String[] args) {
        super(args);
        ModuleLauncher.BaseConfigureLogging((Level)Level.ERROR);
        this.root = new LocalRoot("MSGViewer", "MSGViewer", false, false);
        this.root.setBaseLanguage("en");
        this.root.setDefaultLanguage("en");
        this.root.setLanguageTranslationResourcePath("/net/sourceforge/MSGViewer/resources/translations");
    }

    public void invoke() {
        if (this.getStartupFlag("-h")) {
            CLIHelpMSGViewer help = new CLIHelpMSGViewer(this);
            help.printHelpScreen();
            return;
        }
        if (this.getStartupFlag("-v")) {
            CLIHelpMSGViewer help = new CLIHelpMSGViewer(this);
            help.printVersion();
            System.out.println("Copyright (C) 2015  Martin Oberzalek <msgviewer@hoffer.cx>\n\nThis program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 3 of the License, or\n(at your option) any later version.   \n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software Foundation,\nInc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA\n");
            return;
        }
        CLIFileConverter converter = null;
        if (this.getStartupFlag("-msg2mbox")) {
            converter = new Msg2MBox(this);
        } else if (this.getStartupFlag("-mbox2msg")) {
            converter = new MBox2Msg(this);
        } else if (this.getStartupFlag("-msg2eml")) {
            converter = new Msg2Eml(this);
        }
        if (converter != null) {
            converter.work();
        } else {
            this.invokeGui();
        }
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public void invokeGui() {
        if (this.splashEnabled()) {
            this.splash = new StartupWindow("/at/redeye/FrameWork/base/resources/pictures/redeye.png");
        }
        AppConfigDefinitions.registerDefinitions();
        FrameWorkConfigDefinitions.registerDefinitions();
        if (Setup.is_win_system()) {
            this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new at.redeye.Plugins.ShellExec.Plugin());
        }
        this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new Plugin());
        this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new net.sourceforge.MSGViewer.Plugins.tnef.Plugin());
        this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new net.sourceforge.MSGViewer.Plugins.poi.Plugin());
        this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new net.sourceforge.MSGViewer.Plugins.javamail.Plugin());
        this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new at.redeye.Plugins.CommonsLang.Plugin());
        this.root.registerPlugin((at.redeye.FrameWork.Plugin.Plugin)new at.redeye.Plugins.JerichoHtml.Plugin());
        this.setLookAndFeel(this.root);
        this.configureLogging();
        for (String arg : this.args) {
            if (!arg.toLowerCase().endsWith(".msg") && !arg.toLowerCase().endsWith(".mbox") && !arg.toLowerCase().endsWith(".eml")) continue;
            BaseDialog win = null;
            win = this.getStartupFlag("-mainwin") ? new MainWin(this.root, arg) : new SingleWin(this.root, arg);
            if (this.mainwin == null) {
                this.mainwin = win;
                continue;
            }
            if (this.getStartupFlag("-hidemenubar")) {
                win.hideMenuBar();
            }
            win.setVisible(true);
        }
        if (this.mainwin == null) {
            this.mainwin = this.getStartupFlag("-mainwin") ? new MainWin(this.root, null) : new SingleWin(this.root, null);
        }
        if (this.getStartupFlag("-hidemenubar")) {
            this.mainwin.hideMenuBar();
        }
        this.closeSplash();
        this.mainwin.setVisible(true);
    }

    private boolean getStartupFlag(String string) {
        for (String arg : this.args) {
            if (!arg.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new ModuleLauncher(args).invoke();
    }
}

