/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer;

import at.redeye.FrameWork.Plugin.AboutPlugins;
import at.redeye.FrameWork.base.AutoMBox;
import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.BaseDialogBase;
import at.redeye.FrameWork.base.Root;
import at.redeye.FrameWork.base.Setup;
import at.redeye.FrameWork.base.imagestorage.ImageUtils;
import at.redeye.FrameWork.base.prm.impl.gui.LocalConfig;
import at.redeye.FrameWork.utilities.StringUtils;
import at.redeye.Plugins.ShellExec.ShellExec;
import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.attachment.Attachment;
import com.auxilii.msgparser.attachment.FileAttachment;
import com.auxilii.msgparser.attachment.MsgAttachment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.sourceforge.MSGViewer.About;
import net.sourceforge.MSGViewer.AppConfigDefinitions;
import net.sourceforge.MSGViewer.BodyActionPopup;
import net.sourceforge.MSGViewer.EditorDropTarget;
import net.sourceforge.MSGViewer.HeaderActionPopup;
import net.sourceforge.MSGViewer.Internals;
import net.sourceforge.MSGViewer.LoadMessageInterface;
import net.sourceforge.MSGViewer.LocalHelpWin;
import net.sourceforge.MSGViewer.MSGFileFilter;
import net.sourceforge.MSGViewer.MSGNavigator.MSGNavigator;
import net.sourceforge.MSGViewer.MainDialog;
import net.sourceforge.MSGViewer.PrepareImages;
import net.sourceforge.MSGViewer.ViewerHelper;
import net.sourceforge.MSGViewer.factory.MessageParserFactory;
import net.sourceforge.MSGViewer.rtfparser.ParseException;

public class MainWin
extends BaseDialog
implements HyperlinkListener,
MainDialog,
LoadMessageInterface {
    private Message message;
    private String file_name;
    private String dialog_id;
    private MessageParserFactory parser_factory = new MessageParserFactory();
    private String bodyText = null;
    private ViewerHelper helper = null;
    private static String last_path = null;
    int wating_thread_pool_counter = 0;
    URL lastUrl = null;
    private JCheckBox JCBfix;
    private JEditorPane body;
    private JEditorPane header;
    private JLabel jLabel1;
    private JMenuItem jMAbout;
    private JMenuItem jMChangeLog;
    private JMenuItem jMDetail;
    private JMenuItem jMNav;
    private JMenuItem jMOpenFile;
    private JMenuItem jMPlugin;
    private JMenuItem jMQuit;
    private JMenuItem jMSaveAs;
    private JMenuItem jMSettings;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRRTF;
    private JRadioButton jRText;
    private JSlider jSFontSize;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPaneBody;
    private JPopupMenu.Separator jSeparator1;
    private JSplitPane jSplitPane;
    private JMenuBar menubar;

    public MainWin(Root root, final String file_name) {
        super(root, file_name != null ? root.MlM(root.getAppTitle()) + ": " + file_name : root.getAppTitle());
        this.file_name = file_name;
        this.helper = new ViewerHelper(root);
        this.initComponents();
        this.header.addHyperlinkListener(this);
        this.body.addHyperlinkListener(this);
        last_path = root.getSetup().getLocalConfig("LastPath", "");
        if (StringUtils.isYes((String)root.getSetup().getLocalConfig("RTFFormat", "yes"))) {
            this.jRRTF.setSelected(true);
            this.jRText.setSelected(false);
        } else {
            this.jRRTF.setSelected(false);
            this.jRText.setSelected(true);
        }
        this.JCBfix.setSelected(StringUtils.isYes((String)root.getSetup().getLocalConfig("FixedFont", "no")));
        this.JCBfix.setEnabled(this.jRText.isSelected());
        if (file_name == null) {
            this.header.setText(this.MlM("Drag a msg file into this window"));
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWin.this.parse(file_name);
                }
            });
        }
        new EditorDropTarget(this, this.header);
        new EditorDropTarget(this, this.body);
        this.jSplitPane.setDividerLocation(Integer.parseInt(root.getSetup().getLocalConfig("DividerLocation", "150")));
        this.registerActionKeyListener(KeyStroke.getKeyStroke(86, 0), new Runnable(){

            @Override
            public void run() {
                MainWin.this.jMDetailActionPerformed(null);
            }
        });
        this.registerActionKeyListener(KeyStroke.getKeyStroke(78, 0), new Runnable(){

            @Override
            public void run() {
                if (MainWin.this.jMNav.isEnabled()) {
                    MainWin.this.jMNavActionPerformed(null);
                }
            }
        });
    }

    public String getUniqueDialogIdentifier(Object requester) {
        if (this.dialog_id == null) {
            this.dialog_id = super.getUniqueDialogIdentifier(requester);
        }
        return this.dialog_id;
    }

    void cleanUp() {
        if (this.message == null) {
            return;
        }
        this.message = null;
    }

    public void close() {
        this.cleanUp();
        this.root.getSetup().setLocalConfig("LastPath", last_path);
        this.root.getSetup().setLocalConfig("RTFFormat", this.jRRTF.isSelected() ? "yes" : "no");
        this.root.getSetup().setLocalConfig("FixedFont", this.JCBfix.isSelected() ? "yes" : "no");
        this.root.getSetup().setLocalConfig("DividerLocation", String.valueOf(this.jSplitPane.getDividerLocation()));
        this.helper.dispose();
        super.close();
    }

    void parse(final String file_name) {
        if (file_name == null) {
            return;
        }
        this.file_name = file_name;
        this.setWaitCursor();
        new AutoMBox(MainWin.class.getName()){

            public void do_stuff() throws Exception {
                MainWin.this.parse_int(file_name);
            }
        };
        this.setNormalCursor();
    }

    void parse_int(final String file_name) throws IOException, FileNotFoundException, Exception {
        int max_width;
        this.cleanUp();
        final ExecutorService thread_pool = Executors.newCachedThreadPool();
        this.wating_thread_pool_counter = 0;
        File file = new File(file_name);
        if (!file.exists()) {
            throw new FileNotFoundException(this.MlM(String.format("File %s not found", file_name)));
        }
        if (file.getName().toLowerCase().endsWith(".msg")) {
            this.jMNav.setEnabled(true);
        } else {
            this.jMNav.setEnabled(false);
        }
        this.message = this.parser_factory.parseMessage(file);
        last_path = file.getParentFile().getPath();
        StringBuilder sb = new StringBuilder();
        this.setTitle(this.MlM(this.root.getAppTitle()) + ": " + this.message.getSubject());
        sb.append("<html>");
        sb.append("<body style=\"\">");
        sb.append("<b>");
        if (this.message.getSubject() != null) {
            sb.append(this.message.getSubject());
        }
        sb.append("</b>");
        sb.append("<br/>");
        logger.info((Object)("Message From:" + this.message.getFromName() + "\n To:" + this.message.getToName() + "\n Email: " + this.message.getFromEmail()));
        if (this.message.getFromEmail() != null || this.message.getFromName() != null) {
            if (this.message.getFromEmail() == null) {
                sb.append(this.MlM("From:") + this.message.getFromName());
            } else if (this.message.getFromName() == null) {
                sb.append("<a href=\"mailto:");
                sb.append(this.message.getFromEmail());
                sb.append("\">");
                sb.append(this.message.getFromEmail());
            } else {
                sb.append("<a href=\"mailto:");
                sb.append(this.message.getFromEmail());
                sb.append("\">");
                sb.append(this.message.getFromName());
            }
        }
        if (this.message.getFromEmail() != null && this.message.getFromEmail().contains("@")) {
            sb.append(" [");
            sb.append(this.message.getFromEmail());
            sb.append("]");
        }
        sb.append("</a>");
        sb.append("<br/>");
        if (this.message.getDate() != null) {
            sb.append(this.MlM("Date"));
            sb.append(": ");
            sb.append(DateFormat.getDateTimeInstance().format(this.message.getDate()));
            sb.append("<br/>");
        }
        if (this.message.getToEmail() != null || this.message.getToName() != null) {
            sb.append(this.MlM("To:"));
            sb.append(" ");
        }
        if (this.message.getToName() != null) {
            logger.info((Object)("toName: " + this.message.getToName()));
            sb.append(this.message.getToName());
        }
        if (this.message.getToEmail() != null && this.message.getToEmail().contains("@")) {
            if (this.message.getToName() != null) {
                sb.append(" [");
            }
            sb.append(this.message.getToEmail());
            if (this.message.getToName() != null) {
                sb.append("]");
            }
        }
        sb.append("<br>");
        List attachments = this.message.getAttachments();
        final int max_height = max_width = Integer.parseInt(this.root.getSetup().getLocalConfig(AppConfigDefinitions.IconSize));
        for (Attachment att : attachments) {
            File message_dir;
            if (att instanceof FileAttachment) {
                final FileAttachment fatt = (FileAttachment)att;
                sb.append("<a href=\"file://");
                sb.append(fatt.toString());
                sb.append("\">");
                String mime_type = fatt.getMimeTag();
                logger.info((Object)(fatt.toString() + " " + mime_type));
                if (mime_type != null) {
                    if (ViewerHelper.is_image_mime_type(mime_type) && fatt.getSize() < 0x200000L) {
                        message_dir = this.helper.getTmpDir();
                        if (!message_dir.isDirectory() && !message_dir.mkdirs()) {
                            logger.error((Object)("Cannot create tmp dir: " + message_dir.getPath()));
                        } else {
                            final File content = new File(message_dir + "/" + fatt.toString());
                            if (!content.exists()) {
                                ++this.wating_thread_pool_counter;
                                thread_pool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileOutputStream fout = new FileOutputStream(content);
                                            fout.write(fatt.getData());
                                            fout.close();
                                        }
                                        catch (IOException ex) {
                                            BaseDialog.logger.error((Object)ex, (Throwable)ex);
                                        }
                                        --MainWin.this.wating_thread_pool_counter;
                                    }
                                });
                                ++this.wating_thread_pool_counter;
                                thread_pool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            ImageIcon icon = ImageUtils.loadScaledImageIcon((byte[])fatt.getData(), (String)PrepareImages.getFileName(fatt), (int)max_width, (int)max_height);
                                            File file_small = new File(content.getAbsolutePath() + "-small.jpg");
                                            BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                                            Graphics2D g2 = bi.createGraphics();
                                            g2.drawImage(icon.getImage(), 0, 0, null);
                                            g2.dispose();
                                            ImageIO.write((RenderedImage)bi, "jpg", file_small);
                                        }
                                        catch (IOException ex) {
                                            BaseDialog.logger.error((Object)ex, (Throwable)ex);
                                        }
                                        --MainWin.this.wating_thread_pool_counter;
                                    }
                                });
                            }
                            String extra = "/";
                            if (Setup.is_win_system()) {
                                extra = "";
                            }
                            System.out.println(extra + content.getAbsolutePath() + "-small.jpg");
                            sb.append("<img border=0 src=\"file:/" + extra + content.getAbsolutePath() + "-small.jpg\"/> ");
                        }
                    }
                }
                if (ViewerHelper.is_mail_message(fatt.getFilename(), fatt.getMimeTag())) {
                    sb.append("<img border=0 align=\"baseline\" src=\"file:");
                    sb.append(this.helper.getMailIconName(this.helper.getTmpDir()));
                    sb.append("\"/>");
                }
                if (!fatt.getFilename().isEmpty()) {
                    sb.append(fatt.getFilename());
                } else {
                    sb.append(fatt.toString());
                }
                sb.append("</a> ");
                continue;
            }
            if (att instanceof MsgAttachment) {
                MsgAttachment msgAtt = (MsgAttachment)att;
                final Message msg = msgAtt.getMessage();
                message_dir = this.helper.getTmpDir();
                if (!message_dir.isDirectory() && !message_dir.mkdirs()) {
                    logger.error((Object)("Cannot create tmp dir: " + message_dir.getPath()));
                    continue;
                }
                final String sub_file_name = message_dir + "/" + msg.hashCode() + ".mbox";
                thread_pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        new AutoMBox(file_name){

                            public void do_stuff() throws Exception {
                                MessageParserFactory factory = new MessageParserFactory();
                                factory.saveMessage(msg, new File(sub_file_name));
                            }
                        };
                    }
                });
                sb.append("<a href=\"file://");
                sb.append(sub_file_name);
                sb.append("\">");
                sb.append("<img border=0 align=\"baseline\" src=\"file:");
                sb.append(this.helper.getMailIconName(this.helper.getTmpDir()));
                sb.append("\"/>");
                sb.append(msg.getSubject());
                sb.append("</a> &nbsp; ");
                continue;
            }
            logger.error((Object)("unknown Attachment: " + att.toString() + " " + att.getClass().getName()));
        }
        sb.append("</body></html>");
        this.header.setContentType("text/html");
        if (this.wating_thread_pool_counter > 0) {
            this.updateBody();
            new AutoMBox(file_name){

                public void do_stuff() throws Exception {
                    thread_pool.shutdown();
                    if (MainWin.this.wating_thread_pool_counter > 0) {
                        thread_pool.awaitTermination(1L, TimeUnit.DAYS);
                    }
                }
            };
            this.header.setText(sb.toString());
            this.header.setCaretPosition(0);
        } else {
            this.header.setText(sb.toString());
            this.header.setCaretPosition(0);
            this.updateBody();
        }
    }

    private void updateBody() {
        if (this.message == null) {
            return;
        }
        if (this.jRRTF.isSelected() && this.message.getBodyRTF() != null && !this.message.getBodyRTF().isEmpty()) {
            if (this.message.getBodyRTF() == null) {
                return;
            }
            if (this.message.getBodyRTF().contains("\\fromhtml")) {
                AutoMBox am = new AutoMBox(MainWin.class.getName()){

                    public void do_stuff() throws Exception {
                        MainWin.this.body.setContentType("text/html");
                        this.logger.info((Object)"extracting HTML data from RTF Code");
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("\n" + StringUtils.addLineNumbers((String)MainWin.this.message.getBodyRTF())));
                        }
                        MainWin.this.bodyText = MainWin.this.helper.extractHTMLFromRTF(MainWin.this.message.getBodyRTF(), MainWin.this.message);
                        this.logger.trace((Object)MainWin.this.bodyText);
                        MainWin.this.body.setText(MainWin.this.bodyText);
                    }
                };
                if (am.isFailed()) {
                    this.body.setContentType("text/rtf");
                    this.bodyText = this.message.getBodyRTF();
                    this.body.setText(this.bodyText);
                }
            } else if (this.message.getBodyRTF().contains("\\purehtml")) {
                String html;
                this.body.setContentType("text/html");
                PrepareImages prep_images = new PrepareImages(this.helper.getTmpDir().getPath(), this.message);
                this.bodyText = html = prep_images.prepareImages(new StringBuilder(ViewerHelper.stripMetaTags(this.message.getBodyRTF()))).toString();
                this.body.setText(html);
            } else {
                this.body.setContentType("text/rtf");
                this.bodyText = this.message.getBodyRTF();
                this.body.setText(this.message.getBodyRTF());
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            String font = "Dialog,sans-serif;font-size:10px;";
            if (this.JCBfix.isSelected()) {
                font = "Courier New;font-size:10px;";
            }
            sb.append("<pre style=\"font-family:" + font + "\">");
            String text = this.message.getBodyText();
            sb.append(ViewerHelper.prepareText(text));
            sb.append("</pre>");
            sb.append("</body></html>");
            this.body.setContentType("text/html");
            this.bodyText = sb.toString();
            this.body.setText(this.bodyText);
        }
        this.body.setCaretPosition(0);
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.header = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jScrollPaneBody = new JScrollPane();
        this.body = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.jRRTF = new JRadioButton();
        this.jRText = new JRadioButton();
        this.JCBfix = new JCheckBox();
        this.jSFontSize = new JSlider();
        this.jLabel1 = new JLabel();
        this.menubar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMOpenFile = new JMenuItem();
        this.jMSaveAs = new JMenuItem();
        this.jMSettings = new JMenuItem();
        this.jMQuit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMDetail = new JMenuItem();
        this.jMNav = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMAbout = new JMenuItem();
        this.jMChangeLog = new JMenuItem();
        this.jMPlugin = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jSplitPane.setDividerLocation(150);
        this.jSplitPane.setOrientation(0);
        this.header.setEditable(false);
        this.header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWin.this.headerMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.header);
        this.jSplitPane.setTopComponent(this.jScrollPane2);
        this.body.setEditable(false);
        this.body.setDoubleBuffered(true);
        this.body.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWin.this.bodyMouseClicked(evt);
            }
        });
        this.jScrollPaneBody.setViewportView(this.body);
        this.jRRTF.setText("RTF");
        this.jRRTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jRRTFActionPerformed(evt);
            }
        });
        this.jRText.setText("Text");
        this.jRText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jRTextActionPerformed(evt);
            }
        });
        this.JCBfix.setText("Fixed Font");
        this.JCBfix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.JCBfixActionPerformed(evt);
            }
        });
        this.jSFontSize.setMaximum(30);
        this.jSFontSize.setMinimum(1);
        this.jSFontSize.setValue(12);
        this.jSFontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainWin.this.jSFontSizeStateChanged(evt);
            }
        });
        this.jSFontSize.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainWin.this.jSFontSizePropertyChange(evt);
            }
        });
        this.jLabel1.setText("Fontsize");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jRRTF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.JCBfix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSFontSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap(376, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRText).addComponent(this.JCBfix).addComponent(this.jRRTF)).addComponent(this.jSFontSize, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneBody).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPaneBody, -1, 446, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 25, -2)));
        this.jSplitPane.setRightComponent(this.jPanel1);
        this.jMenu1.setText("Program");
        this.jMOpenFile.setText("File Open ...");
        this.jMOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMOpenFileActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMOpenFile);
        this.jMSaveAs.setText("Save File as ...");
        this.jMSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMSaveAsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMSaveAs);
        this.jMSettings.setText("Options");
        this.jMSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMSettingsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMSettings);
        this.jMQuit.setText("Quit");
        this.jMQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMQuitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMQuit);
        this.menubar.add(this.jMenu1);
        this.jMenu2.setText("Info");
        this.jMDetail.setText("Details");
        this.jMDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMDetailActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMDetail);
        this.jMNav.setText("MSG Navigator");
        this.jMNav.setEnabled(false);
        this.jMNav.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMNavActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMNav);
        this.jMenu2.add(this.jSeparator1);
        this.jMAbout.setText("About");
        this.jMAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMAboutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMAbout);
        this.jMChangeLog.setText("Changelog");
        this.jMChangeLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMChangeLogActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMChangeLog);
        this.jMPlugin.setText("Plugins");
        this.jMPlugin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWin.this.jMPluginActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMPlugin);
        this.menubar.add(this.jMenu2);
        this.setJMenuBar(this.menubar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 633, Short.MAX_VALUE));
        this.pack();
    }

    private void jMAboutActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new About(this.root));
    }

    private void jMChangeLogActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new LocalHelpWin(this.root, "ChangeLog"));
    }

    private void jMPluginActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new AboutPlugins(this.root));
    }

    private void jRRTFActionPerformed(ActionEvent evt) {
        this.jRText.setSelected(!this.jRRTF.isSelected());
        this.JCBfix.setEnabled(this.jRText.isSelected());
        this.updateBody();
    }

    private void jRTextActionPerformed(ActionEvent evt) {
        this.jRRTF.setSelected(!this.jRText.isSelected());
        this.JCBfix.setEnabled(this.jRText.isSelected());
        this.updateBody();
    }

    private void JCBfixActionPerformed(ActionEvent evt) {
        this.updateBody();
    }

    private void jMDetailActionPerformed(ActionEvent evt) {
        if (this.message != null) {
            this.invokeDialogUnique((BaseDialogBase)new Internals(this.root, this.message));
        }
    }

    private void headerMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            if (this.lastUrl == null) {
                return;
            }
            HeaderActionPopup popup = new HeaderActionPopup(this, this.lastUrl);
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void bodyMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.message != null) {
            BodyActionPopup popup = new BodyActionPopup(this);
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMNavActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new MSGNavigator(this.root, new File(this.file_name)));
    }

    private void jSFontSizeStateChanged(ChangeEvent evt) {
        EditorKit editor = this.body.getEditorKit();
        if (editor instanceof HTMLEditorKit) {
            Source source = new Source((CharSequence)this.body.getText());
            source.fullSequentialParse();
            ArrayList<String> tags = new ArrayList<String>();
            for (StartTag tag : source.getAllStartTags()) {
                tags.add(tag.getName());
            }
            HTMLEditorKit html_editor = (HTMLEditorKit)editor;
            System.out.println("Value: " + this.jSFontSize.getValue());
            StyleSheet sheet = html_editor.getStyleSheet();
            String rule = "{ font-size: " + this.jSFontSize.getValue() + "pt; }";
            StringBuilder sb = new StringBuilder();
            for (String tag : tags) {
                sb.append(tag);
                sb.append(rule);
            }
            sheet.addRule(sb.toString());
            String text = this.body.getText();
            this.body.setDocument(html_editor.createDefaultDocument());
            this.body.setText(text);
            this.body.setCaretPosition(0);
        } else {
            this.bodyText = this.bodyText.replaceAll("(\\\\fs)([0-9]+)", "$1" + this.jSFontSize.getValue() * 2);
            System.out.println(this.bodyText);
            this.body.setText(this.bodyText);
            this.body.setCaretPosition(0);
        }
    }

    private void jSFontSizePropertyChange(PropertyChangeEvent evt) {
    }

    private void jMQuitActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void jMSettingsActionPerformed(ActionEvent evt) {
        this.invokeDialogUnique((BaseDialogBase)new LocalConfig(this.root));
    }

    private void jMSaveAsActionPerformed(ActionEvent evt) {
        int retval;
        final JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        final FileNameExtensionFilter msg_filter = new FileNameExtensionFilter(this.MlM("Outlook *.msg Datei"), "msg");
        FileNameExtensionFilter mbox_filter = new FileNameExtensionFilter(this.MlM("Unix *.mbox Datei"), "mbox");
        final FileNameExtensionFilter eml_filter = new FileNameExtensionFilter(this.MlM("Thunderbird *.eml Datei"), "eml");
        fc.addChoosableFileFilter(msg_filter);
        fc.addChoosableFileFilter(mbox_filter);
        fc.addChoosableFileFilter(eml_filter);
        fc.setMultiSelectionEnabled(false);
        if (last_path != null) {
            fc.setCurrentDirectory(new File(last_path));
        }
        if ((retval = fc.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        final File file = fc.getSelectedFile();
        new AutoMBox(this.getClass().getName()){

            public void do_stuff() throws Exception {
                File export_file = file;
                if (!(file.getName().toLowerCase().endsWith(".msg") || file.getName().toLowerCase().endsWith(".eml") || file.getName().toLowerCase().endsWith(".mbox"))) {
                    export_file = fc.getFileFilter() == msg_filter ? new File(file.getAbsolutePath() + ".msg") : (fc.getFileFilter() == eml_filter ? new File(file.getAbsolutePath() + ".eml") : new File(file.getAbsolutePath() + ".mbox"));
                }
                MainWin.this.exportFile(MainWin.this.message, export_file);
            }
        };
    }

    private void jMOpenFileActionPerformed(ActionEvent evt) {
        File[] files;
        int retval;
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new MSGFileFilter(this.root));
        fc.setMultiSelectionEnabled(true);
        logger.info((Object)("last path: " + last_path));
        if (last_path != null) {
            fc.setCurrentDirectory(new File(last_path));
        }
        if ((retval = fc.showOpenDialog((Component)((Object)this))) != 0) {
            return;
        }
        for (File file : files = fc.getSelectedFiles()) {
            this.loadMessage(file.getPath());
        }
    }

    @Override
    public void hyperlinkUpdate(final HyperlinkEvent e) {
        new AutoMBox(MainWin.class.getName()){

            public void do_stuff() throws Exception {
                if (MainWin.this.message == null) {
                    return;
                }
                if (!e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                        MainWin.this.lastUrl = e.getURL();
                    } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                        MainWin.this.lastUrl = null;
                    }
                    return;
                }
                MainWin.this.lastUrl = null;
                MainWin.this.openUrl(e.getURL());
            }
        };
    }

    public void openUrl(URL url) throws IOException {
        logger.info((Object)url);
        String protocoll = url.getProtocol();
        if (!protocoll.equals("file")) {
            if (Setup.is_win_system()) {
                logger.info((Object)("opening: " + url));
                ShellExec shell = new ShellExec();
                int ret = shell.execute(url.toString());
                logger.debug((Object)("shell exec returned: " + ret));
            } else {
                String open_command = this.helper.getOpenCommand();
                String command = open_command + " \"" + url.toString() + "\"";
                logger.info((Object)command);
                String[] command_array = new String[]{open_command, url.toString()};
                Process process = Runtime.getRuntime().exec(command_array);
            }
            return;
        }
        File content = this.helper.extractUrl(url, this.message);
        if (content == null) {
            content = new File(url.getFile());
        }
        if (ViewerHelper.is_mail_message(content.toString())) {
            MainWin win = new MainWin(this.root, content.toString());
            if (!this.menubar.isVisible()) {
                win.hideMenuBar();
            }
            this.invokeDialog(win);
        } else if (Setup.is_win_system() && this.root.getPlugin("ShellExec") != null) {
            logger.info((Object)("opening: " + content.getPath()));
            ShellExec shell = new ShellExec();
            int ret = shell.execute(content.getPath());
            logger.debug((Object)("shell exec returned: " + ret));
        } else {
            String open_command = this.helper.getOpenCommand();
            String command = open_command + " \"" + content.getPath() + "\"";
            logger.info((Object)command);
            String[] command_array = new String[]{open_command, content.getPath()};
            Process process = Runtime.getRuntime().exec(command_array);
        }
    }

    @Override
    public void loadMessage(String file_name) {
        logger.info((Object)("filename: " + file_name));
        if (file_name.startsWith("file://")) {
            try {
                file_name = URLDecoder.decode(file_name, "UTF-8");
                file_name = file_name.substring(7);
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)StringUtils.exceptionToString((Exception)ex));
                file_name = file_name.substring(7);
            }
        }
        if (this.message == null) {
            this.parse(file_name);
        } else {
            MainWin win = new MainWin(this.root, file_name);
            if (!this.menubar.isVisible()) {
                win.hideMenuBar();
            }
            this.invokeMainDialog((BaseDialogBase)win);
        }
    }

    public String getLastOpenPath() {
        return last_path;
    }

    public void setLastOpenPath(String path) {
        last_path = path;
    }

    public String getHTMLCode() throws ParseException {
        return this.helper.extractHTMLFromRTF(this.message.getBodyRTF(), this.message);
    }

    public File getMailDirectory() {
        return this.helper.getTmpDir();
    }

    private void exportFile(Message message, File file) throws FileNotFoundException, Exception {
        this.parser_factory.saveMessage(message, file);
    }

    public String getFileName() {
        return this.file_name;
    }

    public void exportFile(File file) throws FileNotFoundException, Exception {
        this.parser_factory.saveMessage(this.message, file);
    }

    @Override
    public void hideMenuBar() {
        this.menubar.setVisible(false);
    }

    public ViewerHelper getHelper() {
        return this.helper;
    }

    File extractUrl(URL url) throws IOException {
        return this.helper.extractUrl(url, this.message);
    }
}

