/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.MSGNavigator;

import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.Root;
import java.awt.Font;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.freeutils.tnef.TNEFUtils;
import net.sourceforge.MSGViewer.MSGNavigator.MSGNavigator;
import net.sourceforge.MSGViewer.factory.msg.lib.ByteConvert;
import net.sourceforge.MSGViewer.factory.msg.lib.MSTimeConvert;
import org.apache.commons.lang3.StringUtils;

public class ShowNode
extends BaseDialog {
    HashMap<String, String> props;
    int max_descr_lenght = 20;
    private JScrollPane jScrollPane1;
    private JTextArea jTHex;

    public ShowNode(Root root, MSGNavigator.TreeNodeContainer cont, HashMap<String, String> props) {
        super(root, root.MlM("Navigate:") + " " + cont.getEntry().getName());
        this.initComponents();
        this.props = props;
        for (String descr : props.values()) {
            if (descr.length() <= this.max_descr_lenght) continue;
            this.max_descr_lenght = descr.length();
        }
        if (cont.getEntry().isDocumentEntry()) {
            if (cont.getEntry().getName().equals("__properties_version1.0")) {
                this.show_properties_entry(cont);
            } else if (cont.getEntry().getName().equals("__substg1.0_00030102")) {
                this.show_entry_stream(cont);
            } else if (cont.getEntry().getName().equals("__substg1.0_00040102")) {
                this.show_string_stream(cont);
            } else if (cont.getEntry().getName().equals("__substg1.0_00020102")) {
                this.show_guid_stream(cont);
            } else if (cont.getEntry().getName().matches("__substg1\\.0_[0-9][0-9][0-9][0-9]0102") && cont.getEntry().getParent().getName().equals("__nameid_version1.0")) {
                this.show_nameid_stream(cont);
            } else {
                Object data = null;
                data = cont.getData();
                if (data != null) {
                    if (data instanceof String) {
                        this.jTHex.setText((String)data);
                    } else if (data instanceof byte[]) {
                        int i;
                        StringBuilder sb = new StringBuilder();
                        byte[] bytes = (byte[])data;
                        for (i = 0; i < bytes.length; ++i) {
                            if (i > 0 && i % 20 == 0) {
                                sb.append("\n");
                            }
                            if (bytes[i] == 0) {
                                sb.append("__");
                            } else {
                                sb.append(String.format("%02X", bytes[i]));
                            }
                            sb.append(" ");
                            if (bytes[i] > 30 && bytes[i] < 127) {
                                sb.append(String.format("%c", Character.valueOf((char)bytes[i])));
                            } else {
                                sb.append(" ");
                            }
                            sb.append("  ");
                        }
                        sb.append("\n\nASCII only\n");
                        for (i = 0; i < bytes.length; ++i) {
                            if (i > 0 && i % 20 == 0) {
                                sb.append("\n");
                            }
                            if (bytes[i] <= 30 || bytes[i] >= 127) continue;
                            sb.append(String.format("%c", Character.valueOf((char)bytes[i])));
                        }
                        try {
                            byte[] decBytes = TNEFUtils.decompressRTF((byte[])bytes);
                            sb.append("\n\ndecompressed TNEF\n\n");
                            sb.append(new String(decBytes));
                        }
                        catch (Exception ex) {
                            logger.error((Object)"failed decompressing", (Throwable)ex);
                        }
                        sb.append("\n\n");
                        sb.append(TNEFUtils.toHexString((byte[])bytes));
                        this.jTHex.setText(sb.toString());
                    }
                }
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTHex = new JTextArea();
        this.setDefaultCloseOperation(0);
        this.jTHex.setColumns(20);
        this.jTHex.setFont(new Font("Courier New", 0, 12));
        this.jTHex.setRows(5);
        this.jScrollPane1.setViewportView(this.jTHex);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 438, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void show_properties_entry(MSGNavigator.TreeNodeContainer cont) {
        boolean is_toplevel = false;
        boolean is_attachment = false;
        boolean is_reciepient = false;
        if (cont.getEntry().getParent().getParent() == null) {
            is_toplevel = true;
        } else if (cont.getEntry().getParent().getName().startsWith("__recip_version1.0")) {
            is_reciepient = true;
        } else if (cont.getEntry().getParent().getName().startsWith("__attach_version1.0")) {
            is_attachment = true;
        }
        StringBuilder sb = new StringBuilder();
        byte[] bytes = (byte[])cont.getData();
        sb.append("__properties_version1.0\n");
        sb.append("HEADER\n");
        sb.append("\tRESERVED 8 bytes (should by zero)\n\t\t");
        int offset = 0;
        int i = 0;
        while (i < 8) {
            sb.append(this.formatByte(bytes[offset]));
            ++i;
            ++offset;
        }
        if (is_toplevel) {
            sb.append("\n\n\tNEXT Recipient ID 4 bytes \n\t\t");
            i = 0;
            while (i < 4) {
                sb.append(this.formatByte(bytes[offset]));
                ++i;
                ++offset;
            }
            sb.append("\n\n\tNEXT Attachment ID 4 bytes \n\t\t");
            i = 0;
            while (i < 4) {
                sb.append(this.formatByte(bytes[offset]));
                ++i;
                ++offset;
            }
            sb.append("\n\n\tRecipient Count 4 bytes \n\t\t");
            i = 0;
            while (i < 4) {
                sb.append(this.formatByte(bytes[offset]));
                ++i;
                ++offset;
            }
            sb.append("\n\n\tAttachment Count 4 bytes \n\t\t");
            i = 0;
            while (i < 4) {
                sb.append(this.formatByte(bytes[offset]));
                ++i;
                ++offset;
            }
            sb.append("\n\n\tReserved 8 bytes (should by zero)\n\t\t");
            i = 0;
            while (i < 8) {
                sb.append(this.formatByte(bytes[offset]));
                ++i;
                ++offset;
            }
        }
        sb.append("\n");
        while (offset < bytes.length) {
            sb.append("\n");
            this.dumpPropertyEntry(sb, bytes, offset);
            offset += 16;
        }
        this.jTHex.setText(sb.toString());
    }

    private String formatByte(byte b) {
        if (b == 0) {
            return "__ ";
        }
        return String.format("%02X ", b);
    }

    private String formatByte0(byte b) {
        return String.format("%02X ", b);
    }

    private String formatByte0S(byte b) {
        return String.format("%02X", b);
    }

    private void dumpPropertyEntry(StringBuilder sb, byte[] bytes, int offset) {
        sb.append("TAG: ");
        String tagname = "";
        for (int i = offset + 3; i >= offset; --i) {
            sb.append(this.formatByte0S(bytes[i]));
            tagname = tagname + this.formatByte0S(bytes[i]);
        }
        sb.append(" FLAGS: ");
        if ((bytes[offset += 4] & 1) > 0) {
            sb.append("M");
        } else {
            sb.append("_");
        }
        if ((bytes[offset] & 2) > 0) {
            sb.append("R");
        } else {
            sb.append("_");
        }
        if ((bytes[offset] & 4) > 0) {
            sb.append("W");
        } else {
            sb.append("_");
        }
        sb.append(" VALUE: ");
        int value_start_offset = offset += 4;
        int i = 0;
        while (i < 8) {
            sb.append(this.formatByte0(bytes[offset]));
            ++i;
            ++offset;
        }
        sb.append(" ");
        String descr = StringUtils.defaultString((String)this.props.get(tagname.toLowerCase().substring(0, 4)));
        sb.append(StringUtils.rightPad((String)descr, (int)this.max_descr_lenght));
        String tagtype = tagname.toLowerCase().substring(4);
        if (tagtype.equals("001f")) {
            String res = "";
            for (int i2 = value_start_offset + 3; i2 >= value_start_offset; --i2) {
                res = res + this.formatByte0S(bytes[i2]);
            }
            int length = Integer.valueOf(res, 16);
            sb.append(" PtypString length: ");
            sb.append(String.valueOf(length - 2));
        } else if (tagtype.equals("0102")) {
            String res = "";
            for (int i3 = value_start_offset + 3; i3 >= value_start_offset; --i3) {
                res = res + this.formatByte0S(bytes[i3]);
            }
            int length = Integer.valueOf(res, 16);
            sb.append(" PtypBinary length: ");
            sb.append(String.valueOf(length));
        } else if (tagtype.equals("0040")) {
            sb.append(" PtypTime");
            long val = ByteConvert.convertByteArrayToLong(bytes, value_start_offset);
            sb.append(" ");
            sb.append(val);
            sb.append(": ");
            sb.append(new Date(MSTimeConvert.PtypeTime2Millis(val)).toString());
        } else if (tagtype.equals("000b")) {
            sb.append(" boolean");
        } else if (tagtype.equals("0003")) {
            String res = "";
            for (int i4 = value_start_offset + 3; i4 >= value_start_offset; --i4) {
                res = res + this.formatByte0S(bytes[i4]);
            }
            int length = Integer.valueOf(res, 16);
            sb.append(" PtypInteger32 value: ");
            sb.append(length);
        }
    }

    private void show_string_stream(MSGNavigator.TreeNodeContainer cont) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = (byte[])cont.getData();
        sb.append("String Stream ");
        sb.append(cont.getEntry().getName());
        sb.append("\n\n");
        for (int offset = 0; offset < bytes.length; offset += offset % 4) {
            sb.append("Offset: ");
            sb.append(String.format("%04X", offset));
            sb.append(" ");
            String s_lenght = "";
            for (int i = offset + 3; i >= offset; --i) {
                s_lenght = s_lenght + this.formatByte0S(bytes[i]);
            }
            offset += 4;
            long len = Long.valueOf(s_lenght, 16);
            sb.append(s_lenght);
            sb.append(" (" + len + ")");
            sb.append(": ");
            byte[] s_byte = new byte[(int)len];
            int i = offset;
            int count = 0;
            while ((long)i < (long)offset + len) {
                s_byte[count] = bytes[i];
                ++i;
                ++count;
            }
            offset = (int)((long)offset + len);
            try {
                sb.append(new String(s_byte, "UTF-16LE"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
            sb.append("\n");
        }
        this.jTHex.setText(sb.toString());
    }

    private void show_guid_stream(MSGNavigator.TreeNodeContainer cont) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = (byte[])cont.getData();
        sb.append("GUID Stream ");
        sb.append(cont.getEntry().getName());
        sb.append("\n\n");
        int count = 0;
        int offset = 0;
        while (offset < bytes.length) {
            int i;
            sb.append("INDEX: ");
            sb.append(String.format("% 2d", count + 3));
            sb.append(" {");
            StringBuilder sb_prop_set = new StringBuilder();
            int voffset = offset;
            for (i = voffset + 3; i >= voffset; --i) {
                sb_prop_set.append(this.formatByte0S(bytes[i]));
            }
            sb_prop_set.append("-");
            voffset = offset + 4;
            for (i = voffset + 1; i >= voffset; --i) {
                sb_prop_set.append(this.formatByte0S(bytes[i]));
            }
            sb_prop_set.append("-");
            voffset = offset + 6;
            for (i = voffset + 1; i >= voffset; --i) {
                sb_prop_set.append(this.formatByte0S(bytes[i]));
            }
            sb_prop_set.append("-");
            for (i = voffset = offset + 8; i < voffset + 2; ++i) {
                sb_prop_set.append(this.formatByte0S(bytes[i]));
            }
            sb_prop_set.append("-");
            for (i = voffset = offset + 10; i < voffset + 6; ++i) {
                sb_prop_set.append(this.formatByte0S(bytes[i]));
            }
            sb.append((CharSequence)sb_prop_set);
            sb.append("} ");
            sb.append(this.getPropertySetById(sb_prop_set.toString()));
            sb.append("\n");
            offset += 16;
            ++count;
        }
        this.jTHex.setText(sb.toString());
    }

    private String getPropertySetById(String id) {
        if (id.equals("00020386-0000-0000-C000-000000000046")) {
            return "PS_INTERNET_HEADERS";
        }
        if (id.equals("00020329-0000-0000-C000-000000000046")) {
            return "PS_PUBLIC_STRINGS";
        }
        if (id.equals("00062008-0000-0000-C000-000000000046")) {
            return "PSETID_Common";
        }
        if (id.equals("00062004-0000-0000-C000-000000000046")) {
            return "PSETID_Address";
        }
        if (id.equals("00062002-0000-0000-C000-000000000046")) {
            return "PSETID_Appointment";
        }
        if (id.equals("6ED8DA90-450B-101B-98DA-00AA003F1305")) {
            return "PSETID_Meeting";
        }
        if (id.equals("0006200A-0000-0000-C000-000000000046")) {
            return "PSETID_Log";
        }
        if (id.equals("41F28F13-83F4-4114-A584-EEDB5A6B0BFF")) {
            return "PSETID_Messaging";
        }
        if (id.equals("0006200E-0000-0000-C000-000000000046")) {
            return "PSETID_Note";
        }
        if (id.equals("00062041-0000-0000-C000-000000000046")) {
            return "PSETID_PostRss";
        }
        if (id.equals("00062003-0000-0000-C000-000000000046")) {
            return "PSETID_Task";
        }
        if (id.equals("4442858E-A9E3-4E80-B900-317A210CC15B")) {
            return "PSETID_UnifiedMessaging";
        }
        if (id.equals("00020328-0000-0000-C000-000000000046")) {
            return "PS_MAPI";
        }
        if (id.equals("71035549-0739-4DCB-9163-00F0580DBBDF")) {
            return "PSETID_AirSync";
        }
        if (id.equals("00062040-0000-0000-C000-000000000046")) {
            return "PSETID_Sharing";
        }
        return "";
    }

    private void show_entry_stream(MSGNavigator.TreeNodeContainer cont) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = (byte[])cont.getData();
        sb.append("Entry Stream ");
        sb.append(cont.getEntry().getName());
        sb.append("\n\n");
        for (int offset = 0; offset < bytes.length; offset += 8) {
            int i;
            int i2;
            sb.append("Offset in Stream: ");
            int voffset = offset;
            for (i2 = voffset + 3; i2 >= voffset; --i2) {
                sb.append(this.formatByte0S(bytes[i2]));
            }
            sb.append(" (in HEX) ");
            for (i2 = (voffset += 4) + 3; i2 >= voffset; --i2) {
                sb.append(this.formatByte0S(bytes[i2]));
            }
            String s_guid = "";
            for (i = voffset + 1; i >= voffset; --i) {
                s_guid = s_guid + this.formatByte0S(bytes[i]);
            }
            sb.append(" INDEX: ");
            for (i = (voffset += 2) + 1; i >= voffset; --i) {
                sb.append(this.formatByte0S(bytes[i]));
            }
            sb.append(" GUID: ");
            long guid = Long.valueOf(s_guid, 16);
            boolean is_string = (guid & 1L) > 0L;
            sb.append(String.format("%04X", guid >>= 1));
            sb.append(" ");
            if (is_string) {
                sb.append("STRING ");
            } else {
                sb.append("NUM ");
            }
            sb.append("\n");
        }
        this.jTHex.setText(sb.toString());
    }

    private void show_nameid_stream(MSGNavigator.TreeNodeContainer cont) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = (byte[])cont.getData();
        sb.append("NAMEID Stream ");
        sb.append(cont.getEntry().getName());
        sb.append("\n\n");
        for (int offset = 0; offset < bytes.length; offset += 8) {
            int i;
            sb.append("NAME/CRC-32: ");
            int voffset = offset;
            for (int i2 = voffset + 3; i2 >= voffset; --i2) {
                sb.append(this.formatByte0S(bytes[i2]));
            }
            String s_guid = "";
            for (i = (voffset += 4) + 1; i >= voffset; --i) {
                s_guid = s_guid + this.formatByte0S(bytes[i]);
            }
            sb.append(" INDEX: ");
            for (i = (voffset += 2) + 1; i >= voffset; --i) {
                sb.append(this.formatByte0S(bytes[i]));
            }
            sb.append(" GUID: ");
            long guid = Long.valueOf(s_guid, 16);
            boolean is_string = (guid & 1L) > 0L;
            sb.append(String.format("%04X", guid >>= 1));
            sb.append(" ");
            if (is_string) {
                sb.append("STRING ");
            } else {
                sb.append("NUM ");
            }
            sb.append("\n");
        }
        this.jTHex.setText(sb.toString());
    }
}

