/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.MSGViewer.MSGNavigator;

import at.redeye.FrameWork.base.AutoMBox;
import at.redeye.FrameWork.base.BaseDialog;
import at.redeye.FrameWork.base.Root;
import at.redeye.FrameWork.utilities.StringUtils;
import com.auxilii.msgparser.FieldInformation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.MSGViewer.MSGNavigator.EditNode;
import net.sourceforge.MSGViewer.MSGNavigator.NavActionPopup;
import net.sourceforge.MSGViewer.MSGNavigator.PropertyParser;
import net.sourceforge.MSGViewer.MSGNavigator.ShowNode;
import net.sourceforge.MSGViewer.factory.msg.TopLevelPropertyStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MSGNavigator
extends BaseDialog {
    public static final String SETTING_SHOW_SIZE = "MSG_NAVIGATOR_SHOW_SIZE";
    public static final String SETTING_AUTOSAVE = "MSG_SETTING_AUTOSAVE";
    static final HashMap<String, String> props = new HashMap();
    POIFSFileSystem fs;
    File file;
    boolean setting_show_size = false;
    private JScrollPane jScrollPane1;
    private JTree tree;

    public MSGNavigator(Root root, File file) {
        super(root, root.MlM("Navigate:") + " " + file.getName());
        this.initComponents();
        this.file = file;
        this.reload();
    }

    void reload() {
        this.setting_show_size = StringUtils.isYes((String)this.root.getSetup().getLocalConfig(SETTING_SHOW_SIZE, "true"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AutoMBox(MSGNavigator.class.getName()){

                    public void do_stuff() throws Exception {
                        MSGNavigator.this.parse(MSGNavigator.this.file);
                    }
                };
            }
        });
    }

    void parse(File file) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        this.fs = new POIFSFileSystem((InputStream)in);
        DirectoryNode fs_root = this.fs.getRoot();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(fs_root.getShortDescription());
        this.parse(root, (DirectoryEntry)fs_root);
        this.tree.setModel(new DefaultTreeModel(root));
    }

    private void parse(DefaultMutableTreeNode root_node, DirectoryEntry fs_root) throws IOException {
        Iterator iter = fs_root.getEntries();
        while (iter.hasNext()) {
            DirectoryEntry de;
            Entry entry = (Entry)iter.next();
            if (entry.isDirectoryEntry()) {
                de = (DirectoryEntry)entry;
                String name = "<html><body><b style=\"color: blue\">" + entry.getName() + "</b></body></html>";
                TreeNodeContainer node = new TreeNodeContainer((Entry)de, name);
                root_node.add(node);
                this.parse(node, de);
                continue;
            }
            if (!entry.isDocumentEntry()) continue;
            de = (DocumentEntry)entry;
            FieldInformation info = this.analyzeDocumentEntry((DocumentEntry)de);
            DocumentInputStream dstream = new DocumentInputStream((DocumentEntry)de);
            if (de.getName().equals("__properties_version1.0")) {
                info.setType("0102");
            }
            Object data = this.getData(dstream, info);
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            if (entry.getName().startsWith("__properties")) {
                sb.append("<b>");
                sb.append(entry.getName());
                sb.append("</b>");
            } else {
                sb.append(entry.getName());
            }
            sb.append("&nbsp;&nbsp;&nbsp;");
            String property_name = props.get(info.getClazz());
            if (property_name != null) {
                sb.append(" <code style=\"color: green\">" + property_name + "</code> ");
            }
            if (this.setting_show_size) {
                sb.append(" ").append(de.getSize()).append("b ");
            }
            if (data instanceof String) {
                String s = (String)data;
                if (s.length() > 100) {
                    s = s.substring(0, 100) + "...";
                }
                sb.append("     <i>" + s + "</i>");
            } else if (data instanceof byte[]) {
                byte[] bytes = (byte[])data;
                sb.append("     <i style=\"color: dd5555\">byte array</i>");
            }
            sb.append("</body></html>");
            TreeNodeContainer node = new TreeNodeContainer(entry, sb.toString());
            node.setData(data);
            if (de.getName().equals("__properties_version1.0")) {
                try {
                    PropertyParser pp = new PropertyParser((DocumentEntry)de);
                    for (PropertyParser.PropertyTag tag : pp.getPropertyTags()) {
                        PropertyContainer pnode = new PropertyContainer(entry, "<html><body><pre style=\"font-family: monospace; fonz-size:8px\">" + tag.toString() + "</pre></body></html>", tag);
                        node.add(pnode);
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            root_node.add(node);
        }
    }

    protected Object getData(DocumentInputStream dstream, FieldInformation info) throws IOException {
        if (info == null || info.getType() == "unknown") {
            return null;
        }
        if (info.getType().equals("001e")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = dstream.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            String text = new String(baos.toByteArray(), "ISO-8859-1");
            return text;
        }
        if (info.getType().equals("001f")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = dstream.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            byte[] bytes = baos.toByteArray();
            String text = new String(bytes, "UTF-16LE");
            return text;
        }
        if (info.getType().equals("0102")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = dstream.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            return baos.toByteArray();
        }
        if (info.getType().equals("0000")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            StringBuilder sb = new StringBuilder();
            while ((read = dstream.read(buffer)) > 0) {
                for (int i = 0; i < read; ++i) {
                    sb.append(buffer[i]);
                    sb.append(" ");
                }
            }
            return sb.toString();
        }
        logger.trace((Object)("Unknown field type " + info.getType()));
        return null;
    }

    protected FieldInformation analyzeDocumentEntry(DocumentEntry de) {
        String name = de.getName();
        logger.trace((Object)("Document entry: " + name));
        String key = "__substg1.";
        if (name.startsWith(key)) {
            String clazz = "unknown";
            String type = "unknown";
            try {
                String val = name.substring(key.length() + 2).toLowerCase();
                clazz = val.substring(0, 4);
                type = val.substring(4);
                logger.trace((Object)("  Found document entry: class=" + clazz + ", type=" + type + " size: " + de.getSize()));
            }
            catch (RuntimeException re) {
                logger.trace((Object)("Could not parse directory entry " + name + " " + re));
            }
            return new FieldInformation(clazz, type);
        }
        logger.trace((Object)("Ignoring entry with name " + name + " size: " + de.getSize()));
        return new FieldInformation();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(250, 250));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MSGNavigator.this.treeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 611, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 463, Short.MAX_VALUE));
        this.pack();
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            TreePath path = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                for (int x = evt.getX(); x > 0 && path == null; x -= 10) {
                    path = this.tree.getPathForLocation(x, evt.getY());
                }
            }
            if (path != null) {
                this.tree.setSelectionPath(path);
            }
            NavActionPopup popup = new NavActionPopup(this);
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void deleteSelectedElement() {
        new AutoMBox(((Object)((Object)this)).getClass().getName()){

            public void do_stuff() throws Exception {
                TreePath path = MSGNavigator.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                TreeNodeContainer cont = (TreeNodeContainer)path.getLastPathComponent();
                this.logger.info((Object)("deleting : " + cont.getEntry().getName()));
                TopLevelPropertyStream tops = new TopLevelPropertyStream((DirectoryEntry)MSGNavigator.this.fs.getRoot());
                tops.delete(cont.getEntry());
                cont.removeFromParent();
                MSGNavigator.this.tree.updateUI();
                if (StringUtils.isYes((String)MSGNavigator.this.root.getSetup().getLocalConfig(MSGNavigator.SETTING_AUTOSAVE, "false"))) {
                    MSGNavigator.this.save();
                    MSGNavigator.this.reload();
                }
            }
        };
    }

    void save() throws FileNotFoundException, IOException {
        if (this.fs == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(this.file);
        this.fs.writeFilesystem((OutputStream)out);
        ((OutputStream)out).close();
    }

    public void close() {
        this.root.getSetup().setLocalConfig(SETTING_SHOW_SIZE, String.valueOf(this.setting_show_size));
        super.close();
    }

    void showSelectedElement() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        TreeNodeContainer cont = (TreeNodeContainer)path.getLastPathComponent();
        this.invokeDialog(new ShowNode(this.root, cont, props));
    }

    void editSelectedElement() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        TreeNodeContainer cont = (TreeNodeContainer)path.getLastPathComponent();
        this.invokeDialog(new EditNode(this.root, this, cont));
    }

    void edited() throws FileNotFoundException, IOException {
        if (StringUtils.isYes((String)this.root.getSetup().getLocalConfig(SETTING_AUTOSAVE, "false"))) {
            this.save();
            this.reload();
        }
    }

    static {
        props.put("001a", "Message Class");
        props.put("1035", "MessageId");
        props.put("0037", "Subject");
        props.put("0c1f", "FromEmail");
        props.put("0042", "FromName");
        props.put("0076", "ToEmail");
        props.put("3001", "ToName");
        props.put("0e04", "PidTagDisplayTo");
        props.put("0e03", "DisplayCc");
        props.put("0e02", "DisplayBcc");
        props.put("1000", "BodyText");
        props.put("1009", "RTFBodyText");
        props.put("007d", "Headers");
        props.put("0044", "recv name");
        props.put("004d", "author");
        props.put("0050", "reply");
        props.put("005a", "sender");
        props.put("0065", "sent email");
        props.put("0076", "received email");
        props.put("0078", "repr. email");
        props.put("0c1a", "sender name");
        props.put("0e1d", "subject normalized");
        props.put("1046", "sender email");
        props.put("3003", "email address");
        props.put("1008", "rtf sync");
        props.put("3701", "attachment data");
        props.put("3704", "file name");
        props.put("3707", "long Filen name");
        props.put("370e", "mime tag");
        props.put("3703", "extension");
        props.put("0041", "PidTagSentRepresentingEntryId");
        props.put("0c19", "PidTagSenderEntryId");
        props.put("0c1e", "PidTagSenderAddressType");
        props.put("0064", "PidTagSentRepresentingAddressType");
        props.put("0070", "PidTagConversationTopic");
        props.put("300b", "PidTagSearchKey");
        props.put("0002", "<b>GUID Stream</b>");
        props.put("0003", "<b>Entry Stream</b>");
        props.put("0004", "<b>String Stream</b>");
        props.put("3007", "PidTagCreationTime");
        props.put("3008", "PidTagLastModificationTime");
        props.put("0ff7", "PidTagAccessLevel");
        props.put("0ff4", "PidTagAccess");
        props.put("340d", "PidTagStoreSupportMask");
        props.put("0039", "PidTagClientSubmitTime");
        props.put("0e1f", "PidTagRtfInSync");
        props.put("003b", "PidTagSentRepresentingSearchKey");
        props.put("003f", "PidTagReceivedByEntryId");
        props.put("0051", "PidTagReceivedBySearchKey");
        props.put("0070", "PidTagConversationTopic");
        props.put("0071", "PidTagConversationIndex");
        props.put("0075", "PidTagReceivedByAddressType");
        props.put("0c1d", "PidTagSenderSearchKey");
        props.put("0e06", "PidTagMessageDeliveryTime");
        props.put("0e07", "PidTagMessageFlags");
        props.put("0e28", "PidTagPrimarySendAccount");
        props.put("0e29", "PidTagNextSendAcct");
        props.put("3fde", "PidTagInternetCodepage");
        props.put("003d", "PidTagSubjectPrefix");
        props.put("0c15", "PidTagRecipientType");
        props.put("0fff", "PidTagEntryId");
        props.put("3002", "PidTagAddressType");
        props.put("0ff6", "PidTagInstanceKey");
        props.put("3000", "PidTagRowid");
        props.put("3712", "PidTagAttachContentId");
        props.put("8007", "PidLidContactItemData");
        props.put("", "");
        props.put("", "");
        props.put("", "");
    }

    public static class PropertyContainer
    extends TreeNodeContainer {
        private PropertyParser.PropertyTag tag;

        public PropertyContainer(Entry entry, String name, PropertyParser.PropertyTag property_tag) {
            super(entry, name);
            this.tag = property_tag;
        }

        public PropertyParser.PropertyTag getPropertyTag() {
            return this.tag;
        }
    }

    public static class TreeNodeContainer
    extends DefaultMutableTreeNode {
        Entry entry;
        Object data;

        public TreeNodeContainer(Entry entry, String name) {
            super(name);
            this.entry = entry;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

