/*
 * Decompiled with CFR 0.152.
 */
package com.auxilii.msgparser;

import com.auxilii.msgparser.FieldInformation;
import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.RecipientEntry;
import com.auxilii.msgparser.attachment.FileAttachment;
import com.auxilii.msgparser.attachment.MsgAttachment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MsgParser {
    protected static final Logger logger = Logger.getLogger(MsgParser.class.getName());

    public Message parseMsg(File msgFile) throws IOException, UnsupportedOperationException {
        return this.parseMsg(new FileInputStream(msgFile), true);
    }

    public Message parseMsg(String msgFile) throws IOException, UnsupportedOperationException {
        return this.parseMsg(new FileInputStream(msgFile), true);
    }

    public Message parseMsg(InputStream msgFileStream) throws IOException, UnsupportedOperationException {
        return this.parseMsg(msgFileStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message parseMsg(InputStream msgFileStream, boolean closeStream) throws IOException, UnsupportedOperationException {
        Message msg = null;
        try {
            POIFSFileSystem fs = new POIFSFileSystem(msgFileStream);
            DirectoryNode dir = fs.getRoot();
            msg = new Message();
            this.checkDirectoryEntry((DirectoryEntry)dir, msg);
        }
        finally {
            if (closeStream) {
                try {
                    msgFileStream.close();
                }
                catch (Exception e) {}
            }
        }
        return msg;
    }

    protected void checkDirectoryEntry(DirectoryEntry dir, Message msg) throws IOException, UnsupportedOperationException {
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            DirectoryEntry de;
            Entry entry = (Entry)iter.next();
            if (entry.isDirectoryEntry()) {
                de = (DirectoryEntry)entry;
                logger.trace("subdir: " + de.getName());
                if (de.getName().startsWith("__attach_version1.0")) {
                    this.parseAttachment(de, msg, de.getName());
                    continue;
                }
                if (de.getName().startsWith("__recip_version1.0")) {
                    this.checkRecipientDirectoryEntry(de, msg);
                    continue;
                }
                this.checkDirectoryEntry(de, msg);
                continue;
            }
            if (entry.isDocumentEntry()) {
                de = (DocumentEntry)entry;
                logger.trace("entry: " + de.getName());
                DocumentInputStream dstream = new DocumentInputStream((DocumentEntry)de);
                FieldInformation info = this.analyzeDocumentEntry((DocumentEntry)de);
                Object data = this.getData(dstream, info);
                logger.trace("  Document data: " + (data == null ? "null" : data.toString()));
                msg.setProperty(info.getClazz(), data);
                continue;
            }
            logger.info("what happend here? " + entry.getName());
        }
    }

    protected void checkRecipientDirectoryEntry(DirectoryEntry dir, Message msg) throws IOException, UnsupportedOperationException {
        RecipientEntry recipient = new RecipientEntry();
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (entry.isDirectoryEntry() || !entry.isDocumentEntry()) continue;
            DocumentEntry de = (DocumentEntry)entry;
            DocumentInputStream dstream = new DocumentInputStream(de);
            FieldInformation info = this.analyzeDocumentEntry(de);
            Object data = this.getData(dstream, info);
            logger.trace("  Document data: " + (data == null ? "null" : data.toString()));
            recipient.setProperty(info.getClazz(), data);
        }
        msg.addRecipient(recipient);
    }

    protected Object getData(DocumentInputStream dstream, FieldInformation info) throws IOException {
        if (info == null || info.getType() == "unknown") {
            return null;
        }
        if (info.getType().equals("001e")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = dstream.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            String text = new String(baos.toByteArray(), "ISO-8859-1");
            return text;
        }
        if (info.getType().equals("001f")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = dstream.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            byte[] bytes = baos.toByteArray();
            String text = new String(bytes, "UTF-16LE");
            return text;
        }
        if (info.getType().equals("0102")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = dstream.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            return baos.toByteArray();
        }
        if (info.getType().equals("0000")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = -1;
            StringBuilder sb = new StringBuilder();
            while ((read = dstream.read(buffer)) > 0) {
                for (int i = 0; i < read; ++i) {
                    sb.append(buffer[i]);
                    sb.append(" ");
                }
            }
            return sb.toString();
        }
        logger.trace("Unknown field type " + info.getType());
        return null;
    }

    protected FieldInformation analyzeDocumentEntry(DocumentEntry de) {
        String name = de.getName();
        logger.trace("Document entry: " + name);
        String key = "__substg1.";
        if (name.startsWith(key)) {
            String clazz = "unknown";
            String type = "unknown";
            try {
                String val = name.substring(key.length() + 2).toLowerCase();
                clazz = val.substring(0, 4);
                type = val.substring(4);
                logger.trace("  Found document entry: class=" + clazz + ", type=" + type + " size: " + de.getSize());
            }
            catch (RuntimeException re) {
                logger.trace("Could not parse directory entry " + name + " " + re);
            }
            return new FieldInformation(clazz, type);
        }
        logger.trace("Ignoring entry with name " + name + " size: " + de.getSize());
        return new FieldInformation();
    }

    protected void parseAttachment(DirectoryEntry dir, Message msg, String directoryName) throws IOException {
        FileAttachment attachment = new FileAttachment();
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (entry.isDocumentEntry()) {
                int index;
                DocumentEntry de = (DocumentEntry)entry;
                FieldInformation info = this.analyzeDocumentEntry(de);
                DocumentInputStream dstream = new DocumentInputStream(de);
                Object data = this.getData(dstream, info);
                String clazz = info.getClazz();
                attachment.setProperty(clazz, data, de);
                if (directoryName == null || (index = directoryName.indexOf("#")) <= 0) continue;
                attachment.setSubDir(directoryName.substring(index + 1));
                continue;
            }
            Message attachmentMsg = new Message();
            MsgAttachment msgAttachment = new MsgAttachment();
            msgAttachment.setMessage(attachmentMsg);
            msg.addAttachment(msgAttachment);
            this.checkDirectoryEntry((DirectoryEntry)entry, attachmentMsg);
        }
        if (attachment.getSize() > -1L) {
            msg.addAttachment(attachment);
        }
    }
}

